package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeRulesPackagesRequest(
    rulesPackageArns: Iterable[Arn],
    locale: Optional[zio.aws.inspector.model.Locale] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesRequest = {
    import DescribeRulesPackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesRequest
      .builder()
      .rulesPackageArns(rulesPackageArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeRulesPackagesRequest.ReadOnly =
    zio.aws.inspector.model.DescribeRulesPackagesRequest.wrap(buildAwsValue())
}
object DescribeRulesPackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeRulesPackagesRequest =
      zio.aws.inspector.model.DescribeRulesPackagesRequest(
        rulesPackageArns,
        locale.map(value => value)
      )
    def rulesPackageArns: List[Arn]
    def locale: Optional[zio.aws.inspector.model.Locale]
    def getRulesPackageArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(rulesPackageArns)
    def getLocale: ZIO[Any, AwsError, zio.aws.inspector.model.Locale] =
      AwsError.unwrapOptionField("locale", locale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesRequest
  ) extends zio.aws.inspector.model.DescribeRulesPackagesRequest.ReadOnly {
    override val rulesPackageArns: List[Arn] = impl
      .rulesPackageArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val locale: Optional[zio.aws.inspector.model.Locale] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locale())
        .map(value => zio.aws.inspector.model.Locale.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesRequest
  ): zio.aws.inspector.model.DescribeRulesPackagesRequest.ReadOnly =
    new Wrapper(impl)
}
