package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartAssessmentRunResponse(assessmentRunArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.StartAssessmentRunResponse = {
    import StartAssessmentRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.StartAssessmentRunResponse
      .builder()
      .assessmentRunArn(Arn.unwrap(assessmentRunArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.StartAssessmentRunResponse.ReadOnly =
    zio.aws.inspector.model.StartAssessmentRunResponse.wrap(buildAwsValue())
}
object StartAssessmentRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.StartAssessmentRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.StartAssessmentRunResponse =
      zio.aws.inspector.model.StartAssessmentRunResponse(assessmentRunArn)
    def assessmentRunArn: Arn
    def getAssessmentRunArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentRunArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.StartAssessmentRunResponse
  ) extends zio.aws.inspector.model.StartAssessmentRunResponse.ReadOnly {
    override val assessmentRunArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentRunArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.StartAssessmentRunResponse
  ): zio.aws.inspector.model.StartAssessmentRunResponse.ReadOnly = new Wrapper(
    impl
  )
}
