package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait ReportType {
  def unwrap: software.amazon.awssdk.services.inspector.model.ReportType
}
object ReportType {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.ReportType
  ): zio.aws.inspector.model.ReportType = value match {
    case software.amazon.awssdk.services.inspector.model.ReportType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.ReportType.FINDING =>
      val r = FINDING
      r
    case software.amazon.awssdk.services.inspector.model.ReportType.FULL =>
      val r = FULL
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector.model.ReportType {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportType =
      software.amazon.awssdk.services.inspector.model.ReportType.UNKNOWN_TO_SDK_VERSION
  }
  case object FINDING extends zio.aws.inspector.model.ReportType {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportType =
      software.amazon.awssdk.services.inspector.model.ReportType.FINDING
  }
  case object FULL extends zio.aws.inspector.model.ReportType {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportType =
      software.amazon.awssdk.services.inspector.model.ReportType.FULL
  }
}
