package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{PaginationToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssessmentTargetsResponse(
    assessmentTargetArns: Iterable[Arn],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse = {
    import ListAssessmentTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse
      .builder()
      .assessmentTargetArns(assessmentTargetArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListAssessmentTargetsResponse.ReadOnly =
    zio.aws.inspector.model.ListAssessmentTargetsResponse.wrap(buildAwsValue())
}
object ListAssessmentTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentTargetsResponse =
      zio.aws.inspector.model.ListAssessmentTargetsResponse(
        assessmentTargetArns,
        nextToken.map(value => value)
      )
    def assessmentTargetArns: List[Arn]
    def nextToken: Optional[PaginationToken]
    def getAssessmentTargetArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(assessmentTargetArns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse
  ) extends zio.aws.inspector.model.ListAssessmentTargetsResponse.ReadOnly {
    override val assessmentTargetArns: List[Arn] = impl
      .assessmentTargetArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse
  ): zio.aws.inspector.model.ListAssessmentTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
