package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetTagsForResourceRequest(
    resourceArn: Arn,
    tags: Optional[Iterable[zio.aws.inspector.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.SetTagsForResourceRequest = {
    import SetTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.SetTagsForResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.SetTagsForResourceRequest.ReadOnly =
    zio.aws.inspector.model.SetTagsForResourceRequest.wrap(buildAwsValue())
}
object SetTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.SetTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.SetTagsForResourceRequest =
      zio.aws.inspector.model.SetTagsForResourceRequest(
        resourceArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: Arn
    def tags: Optional[List[zio.aws.inspector.model.Tag.ReadOnly]]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.SetTagsForResourceRequest
  ) extends zio.aws.inspector.model.SetTagsForResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.resourceArn())
    override val tags: Optional[List[zio.aws.inspector.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.SetTagsForResourceRequest
  ): zio.aws.inspector.model.SetTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
