package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAssessmentTemplateResponse(assessmentTemplateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateResponse = {
    import CreateAssessmentTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateResponse
      .builder()
      .assessmentTemplateArn(
        Arn.unwrap(assessmentTemplateArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.CreateAssessmentTemplateResponse.ReadOnly =
    zio.aws.inspector.model.CreateAssessmentTemplateResponse
      .wrap(buildAwsValue())
}
object CreateAssessmentTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.CreateAssessmentTemplateResponse =
      zio.aws.inspector.model
        .CreateAssessmentTemplateResponse(assessmentTemplateArn)
    def assessmentTemplateArn: Arn
    def getAssessmentTemplateArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTemplateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateResponse
  ) extends zio.aws.inspector.model.CreateAssessmentTemplateResponse.ReadOnly {
    override val assessmentTemplateArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTemplateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateResponse
  ): zio.aws.inspector.model.CreateAssessmentTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
