package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait AgentHealthCode {
  def unwrap: software.amazon.awssdk.services.inspector.model.AgentHealthCode
}
object AgentHealthCode {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.AgentHealthCode
  ): zio.aws.inspector.model.AgentHealthCode = value match {
    case software.amazon.awssdk.services.inspector.model.AgentHealthCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.AgentHealthCode.IDLE =>
      val r = IDLE
      r
    case software.amazon.awssdk.services.inspector.model.AgentHealthCode.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.inspector.model.AgentHealthCode.SHUTDOWN =>
      val r = SHUTDOWN
      r
    case software.amazon.awssdk.services.inspector.model.AgentHealthCode.UNHEALTHY =>
      val r = UNHEALTHY
      r
    case software.amazon.awssdk.services.inspector.model.AgentHealthCode.THROTTLED =>
      val r = THROTTLED
      r
    case software.amazon.awssdk.services.inspector.model.AgentHealthCode.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector.model.AgentHealthCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealthCode =
      software.amazon.awssdk.services.inspector.model.AgentHealthCode.UNKNOWN_TO_SDK_VERSION
  }
  case object IDLE extends zio.aws.inspector.model.AgentHealthCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealthCode =
      software.amazon.awssdk.services.inspector.model.AgentHealthCode.IDLE
  }
  case object RUNNING extends zio.aws.inspector.model.AgentHealthCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealthCode =
      software.amazon.awssdk.services.inspector.model.AgentHealthCode.RUNNING
  }
  case object SHUTDOWN extends zio.aws.inspector.model.AgentHealthCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealthCode =
      software.amazon.awssdk.services.inspector.model.AgentHealthCode.SHUTDOWN
  }
  case object UNHEALTHY extends zio.aws.inspector.model.AgentHealthCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealthCode =
      software.amazon.awssdk.services.inspector.model.AgentHealthCode.UNHEALTHY
  }
  case object THROTTLED extends zio.aws.inspector.model.AgentHealthCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealthCode =
      software.amazon.awssdk.services.inspector.model.AgentHealthCode.THROTTLED
  }
  case object UNKNOWN extends zio.aws.inspector.model.AgentHealthCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealthCode =
      software.amazon.awssdk.services.inspector.model.AgentHealthCode.UNKNOWN
  }
}
