package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{
  ProviderName,
  Text,
  Arn,
  Version,
  RulesPackageName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RulesPackage(
    arn: Arn,
    name: RulesPackageName,
    version: Version,
    provider: ProviderName,
    description: Optional[Text] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.RulesPackage = {
    import RulesPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.RulesPackage
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .name(RulesPackageName.unwrap(name): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .provider(ProviderName.unwrap(provider): java.lang.String)
      .optionallyWith(
        description.map(value => Text.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.RulesPackage.ReadOnly =
    zio.aws.inspector.model.RulesPackage.wrap(buildAwsValue())
}
object RulesPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.RulesPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.RulesPackage =
      zio.aws.inspector.model.RulesPackage(
        arn,
        name,
        version,
        provider,
        description.map(value => value)
      )
    def arn: Arn
    def name: RulesPackageName
    def version: Version
    def provider: ProviderName
    def description: Optional[Text]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, RulesPackageName] = ZIO.succeed(name)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
    def getProvider: ZIO[Any, Nothing, ProviderName] = ZIO.succeed(provider)
    def getDescription: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.RulesPackage
  ) extends zio.aws.inspector.model.RulesPackage.ReadOnly {
    override val arn: Arn = zio.aws.inspector.model.primitives.Arn(impl.arn())
    override val name: RulesPackageName =
      zio.aws.inspector.model.primitives.RulesPackageName(impl.name())
    override val version: Version =
      zio.aws.inspector.model.primitives.Version(impl.version())
    override val provider: ProviderName =
      zio.aws.inspector.model.primitives.ProviderName(impl.provider())
    override val description: Optional[Text] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.RulesPackage
  ): zio.aws.inspector.model.RulesPackage.ReadOnly = new Wrapper(impl)
}
