package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceGroupTag(
    key: TagKey,
    value: Optional[TagValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ResourceGroupTag = {
    import ResourceGroupTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ResourceGroupTag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ResourceGroupTag.ReadOnly =
    zio.aws.inspector.model.ResourceGroupTag.wrap(buildAwsValue())
}
object ResourceGroupTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ResourceGroupTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ResourceGroupTag =
      zio.aws.inspector.model.ResourceGroupTag(key, value.map(value => value))
    def key: TagKey
    def value: Optional[TagValue]
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ResourceGroupTag
  ) extends zio.aws.inspector.model.ResourceGroupTag.ReadOnly {
    override val key: TagKey =
      zio.aws.inspector.model.primitives.TagKey(impl.key())
    override val value: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.inspector.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ResourceGroupTag
  ): zio.aws.inspector.model.ResourceGroupTag.ReadOnly = new Wrapper(impl)
}
