package zio.aws.inspector.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{
  AmiId,
  AgentId,
  AutoScalingGroup,
  Hostname,
  Ipv4Address,
  NumericVersion
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AssetAttributes(
    schemaVersion: NumericVersion,
    agentId: Optional[AgentId] = Optional.Absent,
    autoScalingGroup: Optional[AutoScalingGroup] = Optional.Absent,
    amiId: Optional[AmiId] = Optional.Absent,
    hostname: Optional[Hostname] = Optional.Absent,
    ipv4Addresses: Optional[Iterable[Ipv4Address]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.inspector.model.Tag]] = Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.inspector.model.NetworkInterface]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssetAttributes = {
    import AssetAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssetAttributes
      .builder()
      .schemaVersion(NumericVersion.unwrap(schemaVersion): Integer)
      .optionallyWith(
        agentId.map(value => AgentId.unwrap(value): java.lang.String)
      )(_.agentId)
      .optionallyWith(
        autoScalingGroup.map(value =>
          AutoScalingGroup.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroup)
      .optionallyWith(
        amiId.map(value => AmiId.unwrap(value): java.lang.String)
      )(_.amiId)
      .optionallyWith(
        hostname.map(value => Hostname.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        ipv4Addresses.map(value =>
          value.map { item =>
            Ipv4Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipv4Addresses)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssetAttributes.ReadOnly =
    zio.aws.inspector.model.AssetAttributes.wrap(buildAwsValue())
}
object AssetAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssetAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssetAttributes =
      zio.aws.inspector.model.AssetAttributes(
        schemaVersion,
        agentId.map(value => value),
        autoScalingGroup.map(value => value),
        amiId.map(value => value),
        hostname.map(value => value),
        ipv4Addresses.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def schemaVersion: NumericVersion
    def agentId: Optional[AgentId]
    def autoScalingGroup: Optional[AutoScalingGroup]
    def amiId: Optional[AmiId]
    def hostname: Optional[Hostname]
    def ipv4Addresses: Optional[List[Ipv4Address]]
    def tags: Optional[List[zio.aws.inspector.model.Tag.ReadOnly]]
    def networkInterfaces
        : Optional[List[zio.aws.inspector.model.NetworkInterface.ReadOnly]]
    def getSchemaVersion: ZIO[Any, Nothing, NumericVersion] =
      ZIO.succeed(schemaVersion)
    def getAgentId: ZIO[Any, AwsError, AgentId] =
      AwsError.unwrapOptionField("agentId", agentId)
    def getAutoScalingGroup: ZIO[Any, AwsError, AutoScalingGroup] =
      AwsError.unwrapOptionField("autoScalingGroup", autoScalingGroup)
    def getAmiId: ZIO[Any, AwsError, AmiId] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getHostname: ZIO[Any, AwsError, Hostname] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getIpv4Addresses: ZIO[Any, AwsError, List[Ipv4Address]] =
      AwsError.unwrapOptionField("ipv4Addresses", ipv4Addresses)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.inspector.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssetAttributes
  ) extends zio.aws.inspector.model.AssetAttributes.ReadOnly {
    override val schemaVersion: NumericVersion =
      zio.aws.inspector.model.primitives.NumericVersion(impl.schemaVersion())
    override val agentId: Optional[AgentId] = zio.aws.core.internal
      .optionalFromNullable(impl.agentId())
      .map(value => zio.aws.inspector.model.primitives.AgentId(value))
    override val autoScalingGroup: Optional[AutoScalingGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroup())
        .map(value =>
          zio.aws.inspector.model.primitives.AutoScalingGroup(value)
        )
    override val amiId: Optional[AmiId] = zio.aws.core.internal
      .optionalFromNullable(impl.amiId())
      .map(value => zio.aws.inspector.model.primitives.AmiId(value))
    override val hostname: Optional[Hostname] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => zio.aws.inspector.model.primitives.Hostname(value))
    override val ipv4Addresses: Optional[List[Ipv4Address]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv4Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.primitives.Ipv4Address(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.inspector.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.Tag.wrap(item)
          }.toList
        )
    override val networkInterfaces
        : Optional[List[zio.aws.inspector.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.NetworkInterface.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssetAttributes
  ): zio.aws.inspector.model.AssetAttributes.ReadOnly = new Wrapper(impl)
}
