package zio.aws.inspector.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetTelemetryMetadataResponse(
    telemetryMetadata: Iterable[zio.aws.inspector.model.TelemetryMetadata]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataResponse = {
    import GetTelemetryMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataResponse
      .builder()
      .telemetryMetadata(telemetryMetadata.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.GetTelemetryMetadataResponse.ReadOnly =
    zio.aws.inspector.model.GetTelemetryMetadataResponse.wrap(buildAwsValue())
}
object GetTelemetryMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.GetTelemetryMetadataResponse =
      zio.aws.inspector.model
        .GetTelemetryMetadataResponse(telemetryMetadata.map { item =>
          item.asEditable
        })
    def telemetryMetadata
        : List[zio.aws.inspector.model.TelemetryMetadata.ReadOnly]
    def getTelemetryMetadata: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.TelemetryMetadata.ReadOnly
    ]] = ZIO.succeed(telemetryMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataResponse
  ) extends zio.aws.inspector.model.GetTelemetryMetadataResponse.ReadOnly {
    override val telemetryMetadata
        : List[zio.aws.inspector.model.TelemetryMetadata.ReadOnly] = impl
      .telemetryMetadata()
      .asScala
      .map { item =>
        zio.aws.inspector.model.TelemetryMetadata.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataResponse
  ): zio.aws.inspector.model.GetTelemetryMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
