package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAssessmentRunRequest(assessmentRunArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunRequest = {
    import DeleteAssessmentRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunRequest
      .builder()
      .assessmentRunArn(Arn.unwrap(assessmentRunArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.DeleteAssessmentRunRequest.ReadOnly =
    zio.aws.inspector.model.DeleteAssessmentRunRequest.wrap(buildAwsValue())
}
object DeleteAssessmentRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DeleteAssessmentRunRequest =
      zio.aws.inspector.model.DeleteAssessmentRunRequest(assessmentRunArn)
    def assessmentRunArn: Arn
    def getAssessmentRunArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentRunArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunRequest
  ) extends zio.aws.inspector.model.DeleteAssessmentRunRequest.ReadOnly {
    override val assessmentRunArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentRunArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunRequest
  ): zio.aws.inspector.model.DeleteAssessmentRunRequest.ReadOnly = new Wrapper(
    impl
  )
}
