package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{
  AgentId,
  AutoScalingGroup,
  Hostname,
  Ipv4Address,
  AgentVersion,
  KernelVersion,
  OperatingSystem
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AgentPreview(
    hostname: Optional[Hostname] = Optional.Absent,
    agentId: AgentId,
    autoScalingGroup: Optional[AutoScalingGroup] = Optional.Absent,
    agentHealth: Optional[zio.aws.inspector.model.AgentHealth] =
      Optional.Absent,
    agentVersion: Optional[AgentVersion] = Optional.Absent,
    operatingSystem: Optional[OperatingSystem] = Optional.Absent,
    kernelVersion: Optional[KernelVersion] = Optional.Absent,
    ipv4Address: Optional[Ipv4Address] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AgentPreview = {
    import AgentPreview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AgentPreview
      .builder()
      .optionallyWith(
        hostname.map(value => Hostname.unwrap(value): java.lang.String)
      )(_.hostname)
      .agentId(AgentId.unwrap(agentId): java.lang.String)
      .optionallyWith(
        autoScalingGroup.map(value =>
          AutoScalingGroup.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroup)
      .optionallyWith(agentHealth.map(value => value.unwrap))(_.agentHealth)
      .optionallyWith(
        agentVersion.map(value => AgentVersion.unwrap(value): java.lang.String)
      )(_.agentVersion)
      .optionallyWith(
        operatingSystem.map(value =>
          OperatingSystem.unwrap(value): java.lang.String
        )
      )(_.operatingSystem)
      .optionallyWith(
        kernelVersion.map(value =>
          KernelVersion.unwrap(value): java.lang.String
        )
      )(_.kernelVersion)
      .optionallyWith(
        ipv4Address.map(value => Ipv4Address.unwrap(value): java.lang.String)
      )(_.ipv4Address)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AgentPreview.ReadOnly =
    zio.aws.inspector.model.AgentPreview.wrap(buildAwsValue())
}
object AgentPreview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AgentPreview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AgentPreview =
      zio.aws.inspector.model.AgentPreview(
        hostname.map(value => value),
        agentId,
        autoScalingGroup.map(value => value),
        agentHealth.map(value => value),
        agentVersion.map(value => value),
        operatingSystem.map(value => value),
        kernelVersion.map(value => value),
        ipv4Address.map(value => value)
      )
    def hostname: Optional[Hostname]
    def agentId: AgentId
    def autoScalingGroup: Optional[AutoScalingGroup]
    def agentHealth: Optional[zio.aws.inspector.model.AgentHealth]
    def agentVersion: Optional[AgentVersion]
    def operatingSystem: Optional[OperatingSystem]
    def kernelVersion: Optional[KernelVersion]
    def ipv4Address: Optional[Ipv4Address]
    def getHostname: ZIO[Any, AwsError, Hostname] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getAgentId: ZIO[Any, Nothing, AgentId] = ZIO.succeed(agentId)
    def getAutoScalingGroup: ZIO[Any, AwsError, AutoScalingGroup] =
      AwsError.unwrapOptionField("autoScalingGroup", autoScalingGroup)
    def getAgentHealth
        : ZIO[Any, AwsError, zio.aws.inspector.model.AgentHealth] =
      AwsError.unwrapOptionField("agentHealth", agentHealth)
    def getAgentVersion: ZIO[Any, AwsError, AgentVersion] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
    def getOperatingSystem: ZIO[Any, AwsError, OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getKernelVersion: ZIO[Any, AwsError, KernelVersion] =
      AwsError.unwrapOptionField("kernelVersion", kernelVersion)
    def getIpv4Address: ZIO[Any, AwsError, Ipv4Address] =
      AwsError.unwrapOptionField("ipv4Address", ipv4Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AgentPreview
  ) extends zio.aws.inspector.model.AgentPreview.ReadOnly {
    override val hostname: Optional[Hostname] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => zio.aws.inspector.model.primitives.Hostname(value))
    override val agentId: AgentId =
      zio.aws.inspector.model.primitives.AgentId(impl.agentId())
    override val autoScalingGroup: Optional[AutoScalingGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroup())
        .map(value =>
          zio.aws.inspector.model.primitives.AutoScalingGroup(value)
        )
    override val agentHealth: Optional[zio.aws.inspector.model.AgentHealth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentHealth())
        .map(value => zio.aws.inspector.model.AgentHealth.wrap(value))
    override val agentVersion: Optional[AgentVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.agentVersion())
      .map(value => zio.aws.inspector.model.primitives.AgentVersion(value))
    override val operatingSystem: Optional[OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.inspector.model.primitives.OperatingSystem(value))
    override val kernelVersion: Optional[KernelVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelVersion())
      .map(value => zio.aws.inspector.model.primitives.KernelVersion(value))
    override val ipv4Address: Optional[Ipv4Address] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4Address())
      .map(value => zio.aws.inspector.model.primitives.Ipv4Address(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AgentPreview
  ): zio.aws.inspector.model.AgentPreview.ReadOnly = new Wrapper(impl)
}
