package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Subscription(
    resourceArn: Arn,
    topicArn: Arn,
    eventSubscriptions: Iterable[zio.aws.inspector.model.EventSubscription]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.Subscription = {
    import Subscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.Subscription
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .topicArn(Arn.unwrap(topicArn): java.lang.String)
      .eventSubscriptions(eventSubscriptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.Subscription.ReadOnly =
    zio.aws.inspector.model.Subscription.wrap(buildAwsValue())
}
object Subscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.Subscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.Subscription =
      zio.aws.inspector.model.Subscription(
        resourceArn,
        topicArn,
        eventSubscriptions.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def topicArn: Arn
    def eventSubscriptions
        : List[zio.aws.inspector.model.EventSubscription.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTopicArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(topicArn)
    def getEventSubscriptions: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.EventSubscription.ReadOnly
    ]] = ZIO.succeed(eventSubscriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.Subscription
  ) extends zio.aws.inspector.model.Subscription.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.resourceArn())
    override val topicArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.topicArn())
    override val eventSubscriptions
        : List[zio.aws.inspector.model.EventSubscription.ReadOnly] = impl
      .eventSubscriptions()
      .asScala
      .map { item =>
        zio.aws.inspector.model.EventSubscription.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.Subscription
  ): zio.aws.inspector.model.Subscription.ReadOnly = new Wrapper(impl)
}
