package zio.aws.inspector.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Iterable[zio.aws.inspector.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListTagsForResourceResponse
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.inspector.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListTagsForResourceResponse =
      zio.aws.inspector.model.ListTagsForResourceResponse(tags.map { item =>
        item.asEditable
      })
    def tags: List[zio.aws.inspector.model.Tag.ReadOnly]
    def getTags: ZIO[Any, Nothing, List[zio.aws.inspector.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListTagsForResourceResponse
  ) extends zio.aws.inspector.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: List[zio.aws.inspector.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.inspector.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListTagsForResourceResponse
  ): zio.aws.inspector.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
