package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssessmentRunAgentsResponse(
    assessmentRunAgents: Iterable[zio.aws.inspector.model.AssessmentRunAgent],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse = {
    import ListAssessmentRunAgentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse
      .builder()
      .assessmentRunAgents(assessmentRunAgents.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListAssessmentRunAgentsResponse.ReadOnly =
    zio.aws.inspector.model.ListAssessmentRunAgentsResponse
      .wrap(buildAwsValue())
}
object ListAssessmentRunAgentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentRunAgentsResponse =
      zio.aws.inspector.model.ListAssessmentRunAgentsResponse(
        assessmentRunAgents.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def assessmentRunAgents
        : List[zio.aws.inspector.model.AssessmentRunAgent.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getAssessmentRunAgents: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.AssessmentRunAgent.ReadOnly
    ]] = ZIO.succeed(assessmentRunAgents)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse
  ) extends zio.aws.inspector.model.ListAssessmentRunAgentsResponse.ReadOnly {
    override val assessmentRunAgents
        : List[zio.aws.inspector.model.AssessmentRunAgent.ReadOnly] = impl
      .assessmentRunAgents()
      .asScala
      .map { item =>
        zio.aws.inspector.model.AssessmentRunAgent.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse
  ): zio.aws.inspector.model.ListAssessmentRunAgentsResponse.ReadOnly =
    new Wrapper(impl)
}
