package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAssessmentTargetRequest(assessmentTargetArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetRequest = {
    import DeleteAssessmentTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetRequest
      .builder()
      .assessmentTargetArn(Arn.unwrap(assessmentTargetArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DeleteAssessmentTargetRequest.ReadOnly =
    zio.aws.inspector.model.DeleteAssessmentTargetRequest.wrap(buildAwsValue())
}
object DeleteAssessmentTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DeleteAssessmentTargetRequest =
      zio.aws.inspector.model.DeleteAssessmentTargetRequest(assessmentTargetArn)
    def assessmentTargetArn: Arn
    def getAssessmentTargetArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTargetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetRequest
  ) extends zio.aws.inspector.model.DeleteAssessmentTargetRequest.ReadOnly {
    override val assessmentTargetArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTargetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetRequest
  ): zio.aws.inspector.model.DeleteAssessmentTargetRequest.ReadOnly =
    new Wrapper(impl)
}
