package zio.aws.inspector
import zio.aws.inspector.model.DescribeAssessmentRunsResponse.ReadOnly
import zio.aws.inspector.model.{
  SubscribeToEventRequest,
  GetExclusionsPreviewRequest,
  ListAssessmentTemplatesRequest,
  GetAssessmentReportRequest,
  CreateAssessmentTargetRequest,
  UnsubscribeFromEventRequest,
  DescribeResourceGroupsRequest,
  DescribeRulesPackagesRequest,
  UpdateAssessmentTargetRequest,
  DescribeAssessmentRunsRequest,
  ListEventSubscriptionsRequest,
  ListTagsForResourceRequest,
  CreateExclusionsPreviewRequest,
  CreateResourceGroupRequest,
  ListAssessmentRunAgentsRequest,
  DescribeExclusionsRequest,
  ListAssessmentRunsRequest,
  AddAttributesToFindingsRequest,
  RemoveAttributesFromFindingsRequest,
  DeleteAssessmentTemplateRequest,
  GetTelemetryMetadataRequest,
  ListFindingsRequest,
  ListAssessmentTargetsRequest,
  DescribeFindingsRequest,
  PreviewAgentsRequest,
  StartAssessmentRunRequest,
  ListRulesPackagesRequest,
  DeleteAssessmentTargetRequest,
  DescribeAssessmentTargetsRequest,
  StopAssessmentRunRequest,
  DescribeAssessmentTemplatesRequest,
  RegisterCrossAccountAccessRoleRequest,
  DeleteAssessmentRunRequest,
  ListExclusionsRequest,
  SetTagsForResourceRequest,
  CreateAssessmentTemplateRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.inspector.InspectorAsyncClient
object InspectorMock extends Mock[Inspector] {
  object StopAssessmentRun
      extends Effect[StopAssessmentRunRequest, AwsError, Unit]
  object ListEventSubscriptions
      extends Effect[
        ListEventSubscriptionsRequest,
        AwsError,
        zio.aws.inspector.model.ListEventSubscriptionsResponse.ReadOnly
      ]
  object ListFindings
      extends Effect[
        ListFindingsRequest,
        AwsError,
        zio.aws.inspector.model.ListFindingsResponse.ReadOnly
      ]
  object UpdateAssessmentTarget
      extends Effect[UpdateAssessmentTargetRequest, AwsError, Unit]
  object StartAssessmentRun
      extends Effect[
        StartAssessmentRunRequest,
        AwsError,
        zio.aws.inspector.model.StartAssessmentRunResponse.ReadOnly
      ]
  object ListAssessmentTemplates
      extends Effect[
        ListAssessmentTemplatesRequest,
        AwsError,
        zio.aws.inspector.model.ListAssessmentTemplatesResponse.ReadOnly
      ]
  object CreateAssessmentTarget
      extends Effect[
        CreateAssessmentTargetRequest,
        AwsError,
        zio.aws.inspector.model.CreateAssessmentTargetResponse.ReadOnly
      ]
  object DescribeAssessmentTargets
      extends Effect[
        DescribeAssessmentTargetsRequest,
        AwsError,
        zio.aws.inspector.model.DescribeAssessmentTargetsResponse.ReadOnly
      ]
  object AddAttributesToFindings
      extends Effect[
        AddAttributesToFindingsRequest,
        AwsError,
        zio.aws.inspector.model.AddAttributesToFindingsResponse.ReadOnly
      ]
  object DescribeResourceGroups
      extends Effect[
        DescribeResourceGroupsRequest,
        AwsError,
        zio.aws.inspector.model.DescribeResourceGroupsResponse.ReadOnly
      ]
  object CreateAssessmentTemplate
      extends Effect[
        CreateAssessmentTemplateRequest,
        AwsError,
        zio.aws.inspector.model.CreateAssessmentTemplateResponse.ReadOnly
      ]
  object DescribeExclusions
      extends Effect[
        DescribeExclusionsRequest,
        AwsError,
        zio.aws.inspector.model.DescribeExclusionsResponse.ReadOnly
      ]
  object UnsubscribeFromEvent
      extends Effect[UnsubscribeFromEventRequest, AwsError, Unit]
  object GetAssessmentReport
      extends Effect[
        GetAssessmentReportRequest,
        AwsError,
        zio.aws.inspector.model.GetAssessmentReportResponse.ReadOnly
      ]
  object RegisterCrossAccountAccessRole
      extends Effect[RegisterCrossAccountAccessRoleRequest, AwsError, Unit]
  object DescribeFindings
      extends Effect[
        DescribeFindingsRequest,
        AwsError,
        zio.aws.inspector.model.DescribeFindingsResponse.ReadOnly
      ]
  object DescribeAssessmentTemplates
      extends Effect[
        DescribeAssessmentTemplatesRequest,
        AwsError,
        zio.aws.inspector.model.DescribeAssessmentTemplatesResponse.ReadOnly
      ]
  object CreateExclusionsPreview
      extends Effect[
        CreateExclusionsPreviewRequest,
        AwsError,
        zio.aws.inspector.model.CreateExclusionsPreviewResponse.ReadOnly
      ]
  object DeleteAssessmentRun
      extends Effect[DeleteAssessmentRunRequest, AwsError, Unit]
  object GetTelemetryMetadata
      extends Effect[
        GetTelemetryMetadataRequest,
        AwsError,
        zio.aws.inspector.model.GetTelemetryMetadataResponse.ReadOnly
      ]
  object GetExclusionsPreview
      extends Effect[
        GetExclusionsPreviewRequest,
        AwsError,
        zio.aws.inspector.model.GetExclusionsPreviewResponse.ReadOnly
      ]
  object ListAssessmentRunAgents
      extends Effect[
        ListAssessmentRunAgentsRequest,
        AwsError,
        zio.aws.inspector.model.ListAssessmentRunAgentsResponse.ReadOnly
      ]
  object PreviewAgents
      extends Effect[
        PreviewAgentsRequest,
        AwsError,
        zio.aws.inspector.model.PreviewAgentsResponse.ReadOnly
      ]
  object ListAssessmentTargets
      extends Effect[
        ListAssessmentTargetsRequest,
        AwsError,
        zio.aws.inspector.model.ListAssessmentTargetsResponse.ReadOnly
      ]
  object SubscribeToEvent
      extends Effect[SubscribeToEventRequest, AwsError, Unit]
  object ListRulesPackages
      extends Effect[
        ListRulesPackagesRequest,
        AwsError,
        zio.aws.inspector.model.ListRulesPackagesResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.inspector.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteAssessmentTarget
      extends Effect[DeleteAssessmentTargetRequest, AwsError, Unit]
  object ListAssessmentRuns
      extends Effect[
        ListAssessmentRunsRequest,
        AwsError,
        zio.aws.inspector.model.ListAssessmentRunsResponse.ReadOnly
      ]
  object DescribeAssessmentRuns
      extends Effect[DescribeAssessmentRunsRequest, AwsError, ReadOnly]
  object DescribeCrossAccountAccessRole
      extends Effect[
        Unit,
        AwsError,
        zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse.ReadOnly
      ]
  object RemoveAttributesFromFindings
      extends Effect[
        RemoveAttributesFromFindingsRequest,
        AwsError,
        zio.aws.inspector.model.RemoveAttributesFromFindingsResponse.ReadOnly
      ]
  object DeleteAssessmentTemplate
      extends Effect[DeleteAssessmentTemplateRequest, AwsError, Unit]
  object CreateResourceGroup
      extends Effect[
        CreateResourceGroupRequest,
        AwsError,
        zio.aws.inspector.model.CreateResourceGroupResponse.ReadOnly
      ]
  object SetTagsForResource
      extends Effect[SetTagsForResourceRequest, AwsError, Unit]
  object DescribeRulesPackages
      extends Effect[
        DescribeRulesPackagesRequest,
        AwsError,
        zio.aws.inspector.model.DescribeRulesPackagesResponse.ReadOnly
      ]
  object ListExclusions
      extends Effect[
        ListExclusionsRequest,
        AwsError,
        zio.aws.inspector.model.ListExclusionsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Inspector] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Inspector {
          val api: InspectorAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Inspector = this
          def stopAssessmentRun(
              request: StopAssessmentRunRequest
          ): IO[AwsError, Unit] = proxy(StopAssessmentRun, request)
          def listEventSubscriptions(
              request: ListEventSubscriptionsRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.ListEventSubscriptionsResponse.ReadOnly
          ] = proxy(ListEventSubscriptions, request)
          def listFindings(request: ListFindingsRequest): IO[
            AwsError,
            zio.aws.inspector.model.ListFindingsResponse.ReadOnly
          ] = proxy(ListFindings, request)
          def updateAssessmentTarget(
              request: UpdateAssessmentTargetRequest
          ): IO[AwsError, Unit] = proxy(UpdateAssessmentTarget, request)
          def startAssessmentRun(request: StartAssessmentRunRequest): IO[
            AwsError,
            zio.aws.inspector.model.StartAssessmentRunResponse.ReadOnly
          ] = proxy(StartAssessmentRun, request)
          def listAssessmentTemplates(
              request: ListAssessmentTemplatesRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.ListAssessmentTemplatesResponse.ReadOnly
          ] = proxy(ListAssessmentTemplates, request)
          def createAssessmentTarget(
              request: CreateAssessmentTargetRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.CreateAssessmentTargetResponse.ReadOnly
          ] = proxy(CreateAssessmentTarget, request)
          def describeAssessmentTargets(
              request: DescribeAssessmentTargetsRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.DescribeAssessmentTargetsResponse.ReadOnly
          ] = proxy(DescribeAssessmentTargets, request)
          def addAttributesToFindings(
              request: AddAttributesToFindingsRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.AddAttributesToFindingsResponse.ReadOnly
          ] = proxy(AddAttributesToFindings, request)
          def describeResourceGroups(
              request: DescribeResourceGroupsRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.DescribeResourceGroupsResponse.ReadOnly
          ] = proxy(DescribeResourceGroups, request)
          def createAssessmentTemplate(
              request: CreateAssessmentTemplateRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.CreateAssessmentTemplateResponse.ReadOnly
          ] = proxy(CreateAssessmentTemplate, request)
          def describeExclusions(request: DescribeExclusionsRequest): IO[
            AwsError,
            zio.aws.inspector.model.DescribeExclusionsResponse.ReadOnly
          ] = proxy(DescribeExclusions, request)
          def unsubscribeFromEvent(
              request: UnsubscribeFromEventRequest
          ): IO[AwsError, Unit] = proxy(UnsubscribeFromEvent, request)
          def getAssessmentReport(request: GetAssessmentReportRequest): IO[
            AwsError,
            zio.aws.inspector.model.GetAssessmentReportResponse.ReadOnly
          ] = proxy(GetAssessmentReport, request)
          def registerCrossAccountAccessRole(
              request: RegisterCrossAccountAccessRoleRequest
          ): IO[AwsError, Unit] = proxy(RegisterCrossAccountAccessRole, request)
          def describeFindings(request: DescribeFindingsRequest): IO[
            AwsError,
            zio.aws.inspector.model.DescribeFindingsResponse.ReadOnly
          ] = proxy(DescribeFindings, request)
          def describeAssessmentTemplates(
              request: DescribeAssessmentTemplatesRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.DescribeAssessmentTemplatesResponse.ReadOnly
          ] = proxy(DescribeAssessmentTemplates, request)
          def createExclusionsPreview(
              request: CreateExclusionsPreviewRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.CreateExclusionsPreviewResponse.ReadOnly
          ] = proxy(CreateExclusionsPreview, request)
          def deleteAssessmentRun(
              request: DeleteAssessmentRunRequest
          ): IO[AwsError, Unit] = proxy(DeleteAssessmentRun, request)
          def getTelemetryMetadata(request: GetTelemetryMetadataRequest): IO[
            AwsError,
            zio.aws.inspector.model.GetTelemetryMetadataResponse.ReadOnly
          ] = proxy(GetTelemetryMetadata, request)
          def getExclusionsPreview(request: GetExclusionsPreviewRequest): IO[
            AwsError,
            zio.aws.inspector.model.GetExclusionsPreviewResponse.ReadOnly
          ] = proxy(GetExclusionsPreview, request)
          def listAssessmentRunAgents(
              request: ListAssessmentRunAgentsRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.ListAssessmentRunAgentsResponse.ReadOnly
          ] = proxy(ListAssessmentRunAgents, request)
          def previewAgents(request: PreviewAgentsRequest): IO[
            AwsError,
            zio.aws.inspector.model.PreviewAgentsResponse.ReadOnly
          ] = proxy(PreviewAgents, request)
          def listAssessmentTargets(request: ListAssessmentTargetsRequest): IO[
            AwsError,
            zio.aws.inspector.model.ListAssessmentTargetsResponse.ReadOnly
          ] = proxy(ListAssessmentTargets, request)
          def subscribeToEvent(
              request: SubscribeToEventRequest
          ): IO[AwsError, Unit] = proxy(SubscribeToEvent, request)
          def listRulesPackages(request: ListRulesPackagesRequest): IO[
            AwsError,
            zio.aws.inspector.model.ListRulesPackagesResponse.ReadOnly
          ] = proxy(ListRulesPackages, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.inspector.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def deleteAssessmentTarget(
              request: DeleteAssessmentTargetRequest
          ): IO[AwsError, Unit] = proxy(DeleteAssessmentTarget, request)
          def listAssessmentRuns(request: ListAssessmentRunsRequest): IO[
            AwsError,
            zio.aws.inspector.model.ListAssessmentRunsResponse.ReadOnly
          ] = proxy(ListAssessmentRuns, request)
          def describeAssessmentRuns(
              request: DescribeAssessmentRunsRequest
          ): IO[AwsError, ReadOnly] = proxy(DescribeAssessmentRuns, request)
          def describeCrossAccountAccessRole(): IO[
            AwsError,
            zio.aws.inspector.model.DescribeCrossAccountAccessRoleResponse.ReadOnly
          ] = proxy(DescribeCrossAccountAccessRole)
          def removeAttributesFromFindings(
              request: RemoveAttributesFromFindingsRequest
          ): IO[
            AwsError,
            zio.aws.inspector.model.RemoveAttributesFromFindingsResponse.ReadOnly
          ] = proxy(RemoveAttributesFromFindings, request)
          def deleteAssessmentTemplate(
              request: DeleteAssessmentTemplateRequest
          ): IO[AwsError, Unit] = proxy(DeleteAssessmentTemplate, request)
          def createResourceGroup(request: CreateResourceGroupRequest): IO[
            AwsError,
            zio.aws.inspector.model.CreateResourceGroupResponse.ReadOnly
          ] = proxy(CreateResourceGroup, request)
          def setTagsForResource(
              request: SetTagsForResourceRequest
          ): IO[AwsError, Unit] = proxy(SetTagsForResource, request)
          def describeRulesPackages(request: DescribeRulesPackagesRequest): IO[
            AwsError,
            zio.aws.inspector.model.DescribeRulesPackagesResponse.ReadOnly
          ] = proxy(DescribeRulesPackages, request)
          def listExclusions(request: ListExclusionsRequest): IO[
            AwsError,
            zio.aws.inspector.model.ListExclusionsResponse.ReadOnly
          ] = proxy(ListExclusions, request)
        }
      }
    }
  }
}
