package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFindingsRequest(
    findingArns: Iterable[Arn],
    locale: Optional[zio.aws.inspector.model.Locale] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeFindingsRequest = {
    import DescribeFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeFindingsRequest
      .builder()
      .findingArns(findingArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.DescribeFindingsRequest.ReadOnly =
    zio.aws.inspector.model.DescribeFindingsRequest.wrap(buildAwsValue())
}
object DescribeFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeFindingsRequest =
      zio.aws.inspector.model
        .DescribeFindingsRequest(findingArns, locale.map(value => value))
    def findingArns: List[Arn]
    def locale: Optional[zio.aws.inspector.model.Locale]
    def getFindingArns: ZIO[Any, Nothing, List[Arn]] = ZIO.succeed(findingArns)
    def getLocale: ZIO[Any, AwsError, zio.aws.inspector.model.Locale] =
      AwsError.unwrapOptionField("locale", locale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeFindingsRequest
  ) extends zio.aws.inspector.model.DescribeFindingsRequest.ReadOnly {
    override val findingArns: List[Arn] = impl
      .findingArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val locale: Optional[zio.aws.inspector.model.Locale] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locale())
        .map(value => zio.aws.inspector.model.Locale.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeFindingsRequest
  ): zio.aws.inspector.model.DescribeFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
