package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{Arn, NamePattern}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssessmentRunFilter(
    namePattern: Optional[NamePattern] = Optional.Absent,
    states: Optional[Iterable[zio.aws.inspector.model.AssessmentRunState]] =
      Optional.Absent,
    durationRange: Optional[zio.aws.inspector.model.DurationRange] =
      Optional.Absent,
    rulesPackageArns: Optional[Iterable[Arn]] = Optional.Absent,
    startTimeRange: Optional[zio.aws.inspector.model.TimestampRange] =
      Optional.Absent,
    completionTimeRange: Optional[zio.aws.inspector.model.TimestampRange] =
      Optional.Absent,
    stateChangeTimeRange: Optional[zio.aws.inspector.model.TimestampRange] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssessmentRunFilter = {
    import AssessmentRunFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssessmentRunFilter
      .builder()
      .optionallyWith(
        namePattern.map(value => NamePattern.unwrap(value): java.lang.String)
      )(_.namePattern)
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .optionallyWith(durationRange.map(value => value.buildAwsValue()))(
        _.durationRange
      )
      .optionallyWith(
        rulesPackageArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rulesPackageArns)
      .optionallyWith(startTimeRange.map(value => value.buildAwsValue()))(
        _.startTimeRange
      )
      .optionallyWith(completionTimeRange.map(value => value.buildAwsValue()))(
        _.completionTimeRange
      )
      .optionallyWith(stateChangeTimeRange.map(value => value.buildAwsValue()))(
        _.stateChangeTimeRange
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssessmentRunFilter.ReadOnly =
    zio.aws.inspector.model.AssessmentRunFilter.wrap(buildAwsValue())
}
object AssessmentRunFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssessmentRunFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssessmentRunFilter =
      zio.aws.inspector.model.AssessmentRunFilter(
        namePattern.map(value => value),
        states.map(value => value),
        durationRange.map(value => value.asEditable),
        rulesPackageArns.map(value => value),
        startTimeRange.map(value => value.asEditable),
        completionTimeRange.map(value => value.asEditable),
        stateChangeTimeRange.map(value => value.asEditable)
      )
    def namePattern: Optional[NamePattern]
    def states: Optional[List[zio.aws.inspector.model.AssessmentRunState]]
    def durationRange: Optional[zio.aws.inspector.model.DurationRange.ReadOnly]
    def rulesPackageArns: Optional[List[Arn]]
    def startTimeRange
        : Optional[zio.aws.inspector.model.TimestampRange.ReadOnly]
    def completionTimeRange
        : Optional[zio.aws.inspector.model.TimestampRange.ReadOnly]
    def stateChangeTimeRange
        : Optional[zio.aws.inspector.model.TimestampRange.ReadOnly]
    def getNamePattern: ZIO[Any, AwsError, NamePattern] =
      AwsError.unwrapOptionField("namePattern", namePattern)
    def getStates
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.AssessmentRunState]] =
      AwsError.unwrapOptionField("states", states)
    def getDurationRange
        : ZIO[Any, AwsError, zio.aws.inspector.model.DurationRange.ReadOnly] =
      AwsError.unwrapOptionField("durationRange", durationRange)
    def getRulesPackageArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("rulesPackageArns", rulesPackageArns)
    def getStartTimeRange
        : ZIO[Any, AwsError, zio.aws.inspector.model.TimestampRange.ReadOnly] =
      AwsError.unwrapOptionField("startTimeRange", startTimeRange)
    def getCompletionTimeRange
        : ZIO[Any, AwsError, zio.aws.inspector.model.TimestampRange.ReadOnly] =
      AwsError.unwrapOptionField("completionTimeRange", completionTimeRange)
    def getStateChangeTimeRange
        : ZIO[Any, AwsError, zio.aws.inspector.model.TimestampRange.ReadOnly] =
      AwsError.unwrapOptionField("stateChangeTimeRange", stateChangeTimeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRunFilter
  ) extends zio.aws.inspector.model.AssessmentRunFilter.ReadOnly {
    override val namePattern: Optional[NamePattern] = zio.aws.core.internal
      .optionalFromNullable(impl.namePattern())
      .map(value => zio.aws.inspector.model.primitives.NamePattern(value))
    override val states
        : Optional[List[zio.aws.inspector.model.AssessmentRunState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.states())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.AssessmentRunState.wrap(item)
          }.toList
        )
    override val durationRange
        : Optional[zio.aws.inspector.model.DurationRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationRange())
        .map(value => zio.aws.inspector.model.DurationRange.wrap(value))
    override val rulesPackageArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.rulesPackageArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.Arn(item)
        }.toList
      )
    override val startTimeRange
        : Optional[zio.aws.inspector.model.TimestampRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimeRange())
        .map(value => zio.aws.inspector.model.TimestampRange.wrap(value))
    override val completionTimeRange
        : Optional[zio.aws.inspector.model.TimestampRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTimeRange())
        .map(value => zio.aws.inspector.model.TimestampRange.wrap(value))
    override val stateChangeTimeRange
        : Optional[zio.aws.inspector.model.TimestampRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateChangeTimeRange())
        .map(value => zio.aws.inspector.model.TimestampRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRunFilter
  ): zio.aws.inspector.model.AssessmentRunFilter.ReadOnly = new Wrapper(impl)
}
