package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait ReportStatus {
  def unwrap: software.amazon.awssdk.services.inspector.model.ReportStatus
}
object ReportStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.ReportStatus
  ): zio.aws.inspector.model.ReportStatus = value match {
    case software.amazon.awssdk.services.inspector.model.ReportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.ReportStatus.WORK_IN_PROGRESS =>
      val r = WORK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.inspector.model.ReportStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.inspector.model.ReportStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector.model.ReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportStatus =
      software.amazon.awssdk.services.inspector.model.ReportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object WORK_IN_PROGRESS extends zio.aws.inspector.model.ReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportStatus =
      software.amazon.awssdk.services.inspector.model.ReportStatus.WORK_IN_PROGRESS
  }
  case object FAILED extends zio.aws.inspector.model.ReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportStatus =
      software.amazon.awssdk.services.inspector.model.ReportStatus.FAILED
  }
  case object COMPLETED extends zio.aws.inspector.model.ReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.ReportStatus =
      software.amazon.awssdk.services.inspector.model.ReportStatus.COMPLETED
  }
}
