package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEventSubscriptionsResponse(
    subscriptions: Iterable[zio.aws.inspector.model.Subscription],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse = {
    import ListEventSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse
      .builder()
      .subscriptions(subscriptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListEventSubscriptionsResponse.ReadOnly =
    zio.aws.inspector.model.ListEventSubscriptionsResponse.wrap(buildAwsValue())
}
object ListEventSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListEventSubscriptionsResponse =
      zio.aws.inspector.model.ListEventSubscriptionsResponse(
        subscriptions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def subscriptions: List[zio.aws.inspector.model.Subscription.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getSubscriptions: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.Subscription.ReadOnly
    ]] = ZIO.succeed(subscriptions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse
  ) extends zio.aws.inspector.model.ListEventSubscriptionsResponse.ReadOnly {
    override val subscriptions
        : List[zio.aws.inspector.model.Subscription.ReadOnly] = impl
      .subscriptions()
      .asScala
      .map { item =>
        zio.aws.inspector.model.Subscription.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse
  ): zio.aws.inspector.model.ListEventSubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
