package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{PaginationToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListExclusionsResponse(
    exclusionArns: Iterable[Arn],
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListExclusionsResponse = {
    import ListExclusionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListExclusionsResponse
      .builder()
      .exclusionArns(exclusionArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListExclusionsResponse.ReadOnly =
    zio.aws.inspector.model.ListExclusionsResponse.wrap(buildAwsValue())
}
object ListExclusionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListExclusionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListExclusionsResponse =
      zio.aws.inspector.model
        .ListExclusionsResponse(exclusionArns, nextToken.map(value => value))
    def exclusionArns: List[Arn]
    def nextToken: Option[PaginationToken]
    def getExclusionArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(exclusionArns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListExclusionsResponse
  ) extends zio.aws.inspector.model.ListExclusionsResponse.ReadOnly {
    override val exclusionArns: List[Arn] = impl
      .exclusionArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListExclusionsResponse
  ): zio.aws.inspector.model.ListExclusionsResponse.ReadOnly = new Wrapper(impl)
}
