package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{AssessmentTargetName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAssessmentTargetRequest(
    assessmentTargetArn: Arn,
    assessmentTargetName: AssessmentTargetName,
    resourceGroupArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetRequest = {
    import UpdateAssessmentTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetRequest
      .builder()
      .assessmentTargetArn(Arn.unwrap(assessmentTargetArn): java.lang.String)
      .assessmentTargetName(
        AssessmentTargetName.unwrap(assessmentTargetName): java.lang.String
      )
      .optionallyWith(
        resourceGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.UpdateAssessmentTargetRequest.ReadOnly =
    zio.aws.inspector.model.UpdateAssessmentTargetRequest.wrap(buildAwsValue())
}
object UpdateAssessmentTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.UpdateAssessmentTargetRequest =
      zio.aws.inspector.model.UpdateAssessmentTargetRequest(
        assessmentTargetArn,
        assessmentTargetName,
        resourceGroupArn.map(value => value)
      )
    def assessmentTargetArn: Arn
    def assessmentTargetName: AssessmentTargetName
    def resourceGroupArn: Option[Arn]
    def getAssessmentTargetArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTargetArn)
    def getAssessmentTargetName: ZIO[Any, Nothing, AssessmentTargetName] =
      ZIO.succeed(assessmentTargetName)
    def getResourceGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceGroupArn", resourceGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetRequest
  ) extends zio.aws.inspector.model.UpdateAssessmentTargetRequest.ReadOnly {
    override val assessmentTargetArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTargetArn())
    override val assessmentTargetName: AssessmentTargetName =
      zio.aws.inspector.model.primitives
        .AssessmentTargetName(impl.assessmentTargetName())
    override val resourceGroupArn: Option[Arn] = scala
      .Option(impl.resourceGroupArn())
      .map(value => zio.aws.inspector.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetRequest
  ): zio.aws.inspector.model.UpdateAssessmentTargetRequest.ReadOnly =
    new Wrapper(impl)
}
