package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{PaginationToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssessmentRunsResponse(
    assessmentRunArns: Iterable[Arn],
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse = {
    import ListAssessmentRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse
      .builder()
      .assessmentRunArns(assessmentRunArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListAssessmentRunsResponse.ReadOnly =
    zio.aws.inspector.model.ListAssessmentRunsResponse.wrap(buildAwsValue())
}
object ListAssessmentRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentRunsResponse =
      zio.aws.inspector.model.ListAssessmentRunsResponse(
        assessmentRunArns,
        nextToken.map(value => value)
      )
    def assessmentRunArns: List[Arn]
    def nextToken: Option[PaginationToken]
    def getAssessmentRunArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(assessmentRunArns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse
  ) extends zio.aws.inspector.model.ListAssessmentRunsResponse.ReadOnly {
    override val assessmentRunArns: List[Arn] = impl
      .assessmentRunArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse
  ): zio.aws.inspector.model.ListAssessmentRunsResponse.ReadOnly = new Wrapper(
    impl
  )
}
