package zio.aws.inspector.model
import java.lang.Integer
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssessmentRunAgentsRequest(
    assessmentRunArn: Arn,
    filter: Option[zio.aws.inspector.model.AgentFilter] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ListMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest = {
    import ListAssessmentRunAgentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest
      .builder()
      .assessmentRunArn(Arn.unwrap(assessmentRunArn): java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListAssessmentRunAgentsRequest.ReadOnly =
    zio.aws.inspector.model.ListAssessmentRunAgentsRequest.wrap(buildAwsValue())
}
object ListAssessmentRunAgentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentRunAgentsRequest =
      zio.aws.inspector.model.ListAssessmentRunAgentsRequest(
        assessmentRunArn,
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentRunArn: Arn
    def filter: Option[zio.aws.inspector.model.AgentFilter.ReadOnly]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ListMaxResults]
    def getAssessmentRunArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentRunArn)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.inspector.model.AgentFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest
  ) extends zio.aws.inspector.model.ListAssessmentRunAgentsRequest.ReadOnly {
    override val assessmentRunArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentRunArn())
    override val filter: Option[zio.aws.inspector.model.AgentFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value => zio.aws.inspector.model.AgentFilter.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Option[ListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest
  ): zio.aws.inspector.model.ListAssessmentRunAgentsRequest.ReadOnly =
    new Wrapper(impl)
}
