package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetTelemetryMetadataRequest(assessmentRunArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataRequest = {
    import GetTelemetryMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataRequest
      .builder()
      .assessmentRunArn(Arn.unwrap(assessmentRunArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.GetTelemetryMetadataRequest.ReadOnly =
    zio.aws.inspector.model.GetTelemetryMetadataRequest.wrap(buildAwsValue())
}
object GetTelemetryMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.GetTelemetryMetadataRequest =
      zio.aws.inspector.model.GetTelemetryMetadataRequest(assessmentRunArn)
    def assessmentRunArn: Arn
    def getAssessmentRunArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentRunArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataRequest
  ) extends zio.aws.inspector.model.GetTelemetryMetadataRequest.ReadOnly {
    override val assessmentRunArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentRunArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataRequest
  ): zio.aws.inspector.model.GetTelemetryMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
