package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateResourceGroupResponse(resourceGroupArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.CreateResourceGroupResponse = {
    import CreateResourceGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.CreateResourceGroupResponse
      .builder()
      .resourceGroupArn(Arn.unwrap(resourceGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.CreateResourceGroupResponse.ReadOnly =
    zio.aws.inspector.model.CreateResourceGroupResponse.wrap(buildAwsValue())
}
object CreateResourceGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.CreateResourceGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.CreateResourceGroupResponse =
      zio.aws.inspector.model.CreateResourceGroupResponse(resourceGroupArn)
    def resourceGroupArn: Arn
    def getResourceGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(resourceGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.CreateResourceGroupResponse
  ) extends zio.aws.inspector.model.CreateResourceGroupResponse.ReadOnly {
    override val resourceGroupArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.resourceGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.CreateResourceGroupResponse
  ): zio.aws.inspector.model.CreateResourceGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
