package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopAssessmentRunRequest(
    assessmentRunArn: Arn,
    stopAction: Option[zio.aws.inspector.model.StopAction] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.StopAssessmentRunRequest = {
    import StopAssessmentRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.StopAssessmentRunRequest
      .builder()
      .assessmentRunArn(Arn.unwrap(assessmentRunArn): java.lang.String)
      .optionallyWith(stopAction.map(value => value.unwrap))(_.stopAction)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.StopAssessmentRunRequest.ReadOnly =
    zio.aws.inspector.model.StopAssessmentRunRequest.wrap(buildAwsValue())
}
object StopAssessmentRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.StopAssessmentRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.StopAssessmentRunRequest =
      zio.aws.inspector.model.StopAssessmentRunRequest(
        assessmentRunArn,
        stopAction.map(value => value)
      )
    def assessmentRunArn: Arn
    def stopAction: Option[zio.aws.inspector.model.StopAction]
    def getAssessmentRunArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentRunArn)
    def getStopAction: ZIO[Any, AwsError, zio.aws.inspector.model.StopAction] =
      AwsError.unwrapOptionField("stopAction", stopAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.StopAssessmentRunRequest
  ) extends zio.aws.inspector.model.StopAssessmentRunRequest.ReadOnly {
    override val assessmentRunArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentRunArn())
    override val stopAction: Option[zio.aws.inspector.model.StopAction] = scala
      .Option(impl.stopAction())
      .map(value => zio.aws.inspector.model.StopAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.StopAssessmentRunRequest
  ): zio.aws.inspector.model.StopAssessmentRunRequest.ReadOnly = new Wrapper(
    impl
  )
}
