package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{PaginationToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRulesPackagesResponse(
    rulesPackageArns: Iterable[Arn],
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse = {
    import ListRulesPackagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse
      .builder()
      .rulesPackageArns(rulesPackageArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListRulesPackagesResponse.ReadOnly =
    zio.aws.inspector.model.ListRulesPackagesResponse.wrap(buildAwsValue())
}
object ListRulesPackagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListRulesPackagesResponse =
      zio.aws.inspector.model.ListRulesPackagesResponse(
        rulesPackageArns,
        nextToken.map(value => value)
      )
    def rulesPackageArns: List[Arn]
    def nextToken: Option[PaginationToken]
    def getRulesPackageArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(rulesPackageArns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse
  ) extends zio.aws.inspector.model.ListRulesPackagesResponse.ReadOnly {
    override val rulesPackageArns: List[Arn] = impl
      .rulesPackageArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse
  ): zio.aws.inspector.model.ListRulesPackagesResponse.ReadOnly = new Wrapper(
    impl
  )
}
