package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAssessmentTargetResponse(assessmentTargetArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetResponse = {
    import CreateAssessmentTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetResponse
      .builder()
      .assessmentTargetArn(Arn.unwrap(assessmentTargetArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.CreateAssessmentTargetResponse.ReadOnly =
    zio.aws.inspector.model.CreateAssessmentTargetResponse.wrap(buildAwsValue())
}
object CreateAssessmentTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.CreateAssessmentTargetResponse =
      zio.aws.inspector.model
        .CreateAssessmentTargetResponse(assessmentTargetArn)
    def assessmentTargetArn: Arn
    def getAssessmentTargetArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTargetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetResponse
  ) extends zio.aws.inspector.model.CreateAssessmentTargetResponse.ReadOnly {
    override val assessmentTargetArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTargetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetResponse
  ): zio.aws.inspector.model.CreateAssessmentTargetResponse.ReadOnly =
    new Wrapper(impl)
}
