package zio.aws.inspector.model
import java.lang.Integer
import zio.aws.inspector.model.primitives.{
  ListMaxResults,
  PaginationToken,
  UUID,
  Arn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetExclusionsPreviewRequest(
    assessmentTemplateArn: Arn,
    previewToken: UUID,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ListMaxResults] = None,
    locale: Option[zio.aws.inspector.model.Locale] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest = {
    import GetExclusionsPreviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest
      .builder()
      .assessmentTemplateArn(
        Arn.unwrap(assessmentTemplateArn): java.lang.String
      )
      .previewToken(UUID.unwrap(previewToken): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.GetExclusionsPreviewRequest.ReadOnly =
    zio.aws.inspector.model.GetExclusionsPreviewRequest.wrap(buildAwsValue())
}
object GetExclusionsPreviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.GetExclusionsPreviewRequest =
      zio.aws.inspector.model.GetExclusionsPreviewRequest(
        assessmentTemplateArn,
        previewToken,
        nextToken.map(value => value),
        maxResults.map(value => value),
        locale.map(value => value)
      )
    def assessmentTemplateArn: Arn
    def previewToken: UUID
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ListMaxResults]
    def locale: Option[zio.aws.inspector.model.Locale]
    def getAssessmentTemplateArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTemplateArn)
    def getPreviewToken: ZIO[Any, Nothing, UUID] = ZIO.succeed(previewToken)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLocale: ZIO[Any, AwsError, zio.aws.inspector.model.Locale] =
      AwsError.unwrapOptionField("locale", locale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest
  ) extends zio.aws.inspector.model.GetExclusionsPreviewRequest.ReadOnly {
    override val assessmentTemplateArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTemplateArn())
    override val previewToken: UUID =
      zio.aws.inspector.model.primitives.UUID(impl.previewToken())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Option[ListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
    override val locale: Option[zio.aws.inspector.model.Locale] = scala
      .Option(impl.locale())
      .map(value => zio.aws.inspector.model.Locale.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest
  ): zio.aws.inspector.model.GetExclusionsPreviewRequest.ReadOnly = new Wrapper(
    impl
  )
}
