package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{AttributeValue, AttributeKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Attribute(
    key: AttributeKey,
    value: Option[AttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.Attribute = {
    import Attribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.Attribute
      .builder()
      .key(AttributeKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => AttributeValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.Attribute.ReadOnly =
    zio.aws.inspector.model.Attribute.wrap(buildAwsValue())
}
object Attribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.Attribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.Attribute =
      zio.aws.inspector.model.Attribute(key, value.map(value => value))
    def key: AttributeKey
    def value: Option[AttributeValue]
    def getKey: ZIO[Any, Nothing, AttributeKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, AttributeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.Attribute
  ) extends zio.aws.inspector.model.Attribute.ReadOnly {
    override val key: AttributeKey =
      zio.aws.inspector.model.primitives.AttributeKey(impl.key())
    override val value: Option[AttributeValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.inspector.model.primitives.AttributeValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.Attribute
  ): zio.aws.inspector.model.Attribute.ReadOnly = new Wrapper(impl)
}
