package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{AttributeKey, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveAttributesFromFindingsRequest(
    findingArns: Iterable[Arn],
    attributeKeys: Iterable[AttributeKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsRequest = {
    import RemoveAttributesFromFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsRequest
      .builder()
      .findingArns(findingArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .attributeKeys(attributeKeys.map { item =>
        AttributeKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.RemoveAttributesFromFindingsRequest.ReadOnly =
    zio.aws.inspector.model.RemoveAttributesFromFindingsRequest
      .wrap(buildAwsValue())
}
object RemoveAttributesFromFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector.model.RemoveAttributesFromFindingsRequest =
      zio.aws.inspector.model
        .RemoveAttributesFromFindingsRequest(findingArns, attributeKeys)
    def findingArns: List[Arn]
    def attributeKeys: List[AttributeKey]
    def getFindingArns: ZIO[Any, Nothing, List[Arn]] = ZIO.succeed(findingArns)
    def getAttributeKeys: ZIO[Any, Nothing, List[AttributeKey]] =
      ZIO.succeed(attributeKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsRequest
  ) extends zio.aws.inspector.model.RemoveAttributesFromFindingsRequest.ReadOnly {
    override val findingArns: List[Arn] = impl
      .findingArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val attributeKeys: List[AttributeKey] = impl
      .attributeKeys()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.AttributeKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsRequest
  ): zio.aws.inspector.model.RemoveAttributesFromFindingsRequest.ReadOnly =
    new Wrapper(impl)
}
