package zio.aws.inspector.model
import java.lang.Integer
import zio.aws.inspector.model.primitives.{
  PreviewAgentsMaxResults,
  PaginationToken,
  Arn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PreviewAgentsRequest(
    previewAgentsArn: Arn,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PreviewAgentsMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest = {
    import PreviewAgentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest
      .builder()
      .previewAgentsArn(Arn.unwrap(previewAgentsArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PreviewAgentsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.PreviewAgentsRequest.ReadOnly =
    zio.aws.inspector.model.PreviewAgentsRequest.wrap(buildAwsValue())
}
object PreviewAgentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.PreviewAgentsRequest =
      zio.aws.inspector.model.PreviewAgentsRequest(
        previewAgentsArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def previewAgentsArn: Arn
    def nextToken: Option[PaginationToken]
    def maxResults: Option[PreviewAgentsMaxResults]
    def getPreviewAgentsArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(previewAgentsArn)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PreviewAgentsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest
  ) extends zio.aws.inspector.model.PreviewAgentsRequest.ReadOnly {
    override val previewAgentsArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.previewAgentsArn())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Option[PreviewAgentsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.inspector.model.primitives.PreviewAgentsMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest
  ): zio.aws.inspector.model.PreviewAgentsRequest.ReadOnly = new Wrapper(impl)
}
