package zio.aws.inspector.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{
  Bool,
  AssessmentRunDuration,
  Timestamp,
  Arn,
  AssessmentRunName,
  FindingCount
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AssessmentRun(
    arn: Arn,
    name: AssessmentRunName,
    assessmentTemplateArn: Arn,
    state: zio.aws.inspector.model.AssessmentRunState,
    durationInSeconds: AssessmentRunDuration,
    rulesPackageArns: Iterable[Arn],
    userAttributesForFindings: Iterable[zio.aws.inspector.model.Attribute],
    createdAt: Timestamp,
    startedAt: Option[Timestamp] = None,
    completedAt: Option[Timestamp] = None,
    stateChangedAt: Timestamp,
    dataCollected: Bool,
    stateChanges: Iterable[zio.aws.inspector.model.AssessmentRunStateChange],
    notifications: Iterable[zio.aws.inspector.model.AssessmentRunNotification],
    findingCounts: Map[zio.aws.inspector.model.Severity, FindingCount]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssessmentRun = {
    import AssessmentRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssessmentRun
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .name(AssessmentRunName.unwrap(name): java.lang.String)
      .assessmentTemplateArn(
        Arn.unwrap(assessmentTemplateArn): java.lang.String
      )
      .state(state.unwrap)
      .durationInSeconds(
        AssessmentRunDuration.unwrap(durationInSeconds): Integer
      )
      .rulesPackageArns(rulesPackageArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .userAttributesForFindings(userAttributesForFindings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(startedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        completedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.completedAt)
      .stateChangedAt(Timestamp.unwrap(stateChangedAt): Instant)
      .dataCollected(dataCollected: java.lang.Boolean)
      .stateChanges(stateChanges.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .notifications(notifications.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .findingCountsWithStrings(
        findingCounts
          .map({ case (key, value) =>
            key.unwrap.toString -> (FindingCount.unwrap(value): Integer)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssessmentRun.ReadOnly =
    zio.aws.inspector.model.AssessmentRun.wrap(buildAwsValue())
}
object AssessmentRun {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssessmentRun
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssessmentRun =
      zio.aws.inspector.model.AssessmentRun(
        arn,
        name,
        assessmentTemplateArn,
        state,
        durationInSeconds,
        rulesPackageArns,
        userAttributesForFindings.map { item =>
          item.asEditable
        },
        createdAt,
        startedAt.map(value => value),
        completedAt.map(value => value),
        stateChangedAt,
        dataCollected,
        stateChanges.map { item =>
          item.asEditable
        },
        notifications.map { item =>
          item.asEditable
        },
        findingCounts
      )
    def arn: Arn
    def name: AssessmentRunName
    def assessmentTemplateArn: Arn
    def state: zio.aws.inspector.model.AssessmentRunState
    def durationInSeconds: AssessmentRunDuration
    def rulesPackageArns: List[Arn]
    def userAttributesForFindings
        : List[zio.aws.inspector.model.Attribute.ReadOnly]
    def createdAt: Timestamp
    def startedAt: Option[Timestamp]
    def completedAt: Option[Timestamp]
    def stateChangedAt: Timestamp
    def dataCollected: Bool
    def stateChanges
        : List[zio.aws.inspector.model.AssessmentRunStateChange.ReadOnly]
    def notifications
        : List[zio.aws.inspector.model.AssessmentRunNotification.ReadOnly]
    def findingCounts: Map[zio.aws.inspector.model.Severity, FindingCount]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, AssessmentRunName] = ZIO.succeed(name)
    def getAssessmentTemplateArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTemplateArn)
    def getState
        : ZIO[Any, Nothing, zio.aws.inspector.model.AssessmentRunState] =
      ZIO.succeed(state)
    def getDurationInSeconds: ZIO[Any, Nothing, AssessmentRunDuration] =
      ZIO.succeed(durationInSeconds)
    def getRulesPackageArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(rulesPackageArns)
    def getUserAttributesForFindings
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      ZIO.succeed(userAttributesForFindings)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getCompletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completedAt", completedAt)
    def getStateChangedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(stateChangedAt)
    def getDataCollected: ZIO[Any, Nothing, Bool] = ZIO.succeed(dataCollected)
    def getStateChanges: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.AssessmentRunStateChange.ReadOnly
    ]] = ZIO.succeed(stateChanges)
    def getNotifications: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.AssessmentRunNotification.ReadOnly
    ]] = ZIO.succeed(notifications)
    def getFindingCounts: ZIO[Any, Nothing, Map[
      zio.aws.inspector.model.Severity,
      FindingCount
    ]] = ZIO.succeed(findingCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRun
  ) extends zio.aws.inspector.model.AssessmentRun.ReadOnly {
    override val arn: Arn = zio.aws.inspector.model.primitives.Arn(impl.arn())
    override val name: AssessmentRunName =
      zio.aws.inspector.model.primitives.AssessmentRunName(impl.name())
    override val assessmentTemplateArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTemplateArn())
    override val state: zio.aws.inspector.model.AssessmentRunState =
      zio.aws.inspector.model.AssessmentRunState.wrap(impl.state())
    override val durationInSeconds: AssessmentRunDuration =
      zio.aws.inspector.model.primitives
        .AssessmentRunDuration(impl.durationInSeconds())
    override val rulesPackageArns: List[Arn] = impl
      .rulesPackageArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
    override val userAttributesForFindings
        : List[zio.aws.inspector.model.Attribute.ReadOnly] = impl
      .userAttributesForFindings()
      .asScala
      .map { item =>
        zio.aws.inspector.model.Attribute.wrap(item)
      }
      .toList
    override val createdAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.createdAt())
    override val startedAt: Option[Timestamp] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.inspector.model.primitives.Timestamp(value))
    override val completedAt: Option[Timestamp] = scala
      .Option(impl.completedAt())
      .map(value => zio.aws.inspector.model.primitives.Timestamp(value))
    override val stateChangedAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.stateChangedAt())
    override val dataCollected: Bool = impl.dataCollected(): Bool
    override val stateChanges
        : List[zio.aws.inspector.model.AssessmentRunStateChange.ReadOnly] = impl
      .stateChanges()
      .asScala
      .map { item =>
        zio.aws.inspector.model.AssessmentRunStateChange.wrap(item)
      }
      .toList
    override val notifications
        : List[zio.aws.inspector.model.AssessmentRunNotification.ReadOnly] =
      impl
        .notifications()
        .asScala
        .map { item =>
          zio.aws.inspector.model.AssessmentRunNotification.wrap(item)
        }
        .toList
    override val findingCounts
        : Map[zio.aws.inspector.model.Severity, FindingCount] = impl
      .findingCounts()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.Severity
          .wrap(key) -> zio.aws.inspector.model.primitives.FindingCount(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRun
  ): zio.aws.inspector.model.AssessmentRun.ReadOnly = new Wrapper(impl)
}
