package zio.aws.inspector.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.inspector.model.primitives.{
  Bool,
  Text,
  Timestamp,
  Arn,
  NumericVersion,
  NumericSeverity,
  IocConfidence,
  FindingId,
  ServiceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Finding(
    arn: Arn,
    schemaVersion: Option[NumericVersion] = None,
    service: Option[ServiceName] = None,
    serviceAttributes: Option[
      zio.aws.inspector.model.InspectorServiceAttributes
    ] = None,
    assetType: Option[zio.aws.inspector.model.AssetType] = None,
    assetAttributes: Option[zio.aws.inspector.model.AssetAttributes] = None,
    id: Option[FindingId] = None,
    title: Option[Text] = None,
    description: Option[Text] = None,
    recommendation: Option[Text] = None,
    severity: Option[zio.aws.inspector.model.Severity] = None,
    numericSeverity: Option[NumericSeverity] = None,
    confidence: Option[IocConfidence] = None,
    indicatorOfCompromise: Option[Bool] = None,
    attributes: Iterable[zio.aws.inspector.model.Attribute],
    userAttributes: Iterable[zio.aws.inspector.model.Attribute],
    createdAt: Timestamp,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.Finding = {
    import Finding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.Finding
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        schemaVersion.map(value => NumericVersion.unwrap(value): Integer)
      )(_.schemaVersion)
      .optionallyWith(
        service.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.service)
      .optionallyWith(serviceAttributes.map(value => value.buildAwsValue()))(
        _.serviceAttributes
      )
      .optionallyWith(assetType.map(value => value.unwrap))(_.assetType)
      .optionallyWith(assetAttributes.map(value => value.buildAwsValue()))(
        _.assetAttributes
      )
      .optionallyWith(
        id.map(value => FindingId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(title.map(value => Text.unwrap(value): java.lang.String))(
        _.title
      )
      .optionallyWith(
        description.map(value => Text.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        recommendation.map(value => Text.unwrap(value): java.lang.String)
      )(_.recommendation)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(
        numericSeverity.map(value =>
          NumericSeverity.unwrap(value): java.lang.Double
        )
      )(_.numericSeverity)
      .optionallyWith(
        confidence.map(value => IocConfidence.unwrap(value): Integer)
      )(_.confidence)
      .optionallyWith(
        indicatorOfCompromise.map(value => value: java.lang.Boolean)
      )(_.indicatorOfCompromise)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .userAttributes(userAttributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.Finding.ReadOnly =
    zio.aws.inspector.model.Finding.wrap(buildAwsValue())
}
object Finding {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector.model.Finding] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.Finding =
      zio.aws.inspector.model.Finding(
        arn,
        schemaVersion.map(value => value),
        service.map(value => value),
        serviceAttributes.map(value => value.asEditable),
        assetType.map(value => value),
        assetAttributes.map(value => value.asEditable),
        id.map(value => value),
        title.map(value => value),
        description.map(value => value),
        recommendation.map(value => value),
        severity.map(value => value),
        numericSeverity.map(value => value),
        confidence.map(value => value),
        indicatorOfCompromise.map(value => value),
        attributes.map { item =>
          item.asEditable
        },
        userAttributes.map { item =>
          item.asEditable
        },
        createdAt,
        updatedAt
      )
    def arn: Arn
    def schemaVersion: Option[NumericVersion]
    def service: Option[ServiceName]
    def serviceAttributes
        : Option[zio.aws.inspector.model.InspectorServiceAttributes.ReadOnly]
    def assetType: Option[zio.aws.inspector.model.AssetType]
    def assetAttributes
        : Option[zio.aws.inspector.model.AssetAttributes.ReadOnly]
    def id: Option[FindingId]
    def title: Option[Text]
    def description: Option[Text]
    def recommendation: Option[Text]
    def severity: Option[zio.aws.inspector.model.Severity]
    def numericSeverity: Option[NumericSeverity]
    def confidence: Option[IocConfidence]
    def indicatorOfCompromise: Option[Bool]
    def attributes: List[zio.aws.inspector.model.Attribute.ReadOnly]
    def userAttributes: List[zio.aws.inspector.model.Attribute.ReadOnly]
    def createdAt: Timestamp
    def updatedAt: Timestamp
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getSchemaVersion: ZIO[Any, AwsError, NumericVersion] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getService: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("service", service)
    def getServiceAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.inspector.model.InspectorServiceAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("serviceAttributes", serviceAttributes)
    def getAssetType: ZIO[Any, AwsError, zio.aws.inspector.model.AssetType] =
      AwsError.unwrapOptionField("assetType", assetType)
    def getAssetAttributes
        : ZIO[Any, AwsError, zio.aws.inspector.model.AssetAttributes.ReadOnly] =
      AwsError.unwrapOptionField("assetAttributes", assetAttributes)
    def getId: ZIO[Any, AwsError, FindingId] =
      AwsError.unwrapOptionField("id", id)
    def getTitle: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("description", description)
    def getRecommendation: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("recommendation", recommendation)
    def getSeverity: ZIO[Any, AwsError, zio.aws.inspector.model.Severity] =
      AwsError.unwrapOptionField("severity", severity)
    def getNumericSeverity: ZIO[Any, AwsError, NumericSeverity] =
      AwsError.unwrapOptionField("numericSeverity", numericSeverity)
    def getConfidence: ZIO[Any, AwsError, IocConfidence] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getIndicatorOfCompromise: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("indicatorOfCompromise", indicatorOfCompromise)
    def getAttributes
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      ZIO.succeed(attributes)
    def getUserAttributes
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      ZIO.succeed(userAttributes)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.Finding
  ) extends zio.aws.inspector.model.Finding.ReadOnly {
    override val arn: Arn = zio.aws.inspector.model.primitives.Arn(impl.arn())
    override val schemaVersion: Option[NumericVersion] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.inspector.model.primitives.NumericVersion(value))
    override val service: Option[ServiceName] = scala
      .Option(impl.service())
      .map(value => zio.aws.inspector.model.primitives.ServiceName(value))
    override val serviceAttributes
        : Option[zio.aws.inspector.model.InspectorServiceAttributes.ReadOnly] =
      scala
        .Option(impl.serviceAttributes())
        .map(value =>
          zio.aws.inspector.model.InspectorServiceAttributes.wrap(value)
        )
    override val assetType: Option[zio.aws.inspector.model.AssetType] = scala
      .Option(impl.assetType())
      .map(value => zio.aws.inspector.model.AssetType.wrap(value))
    override val assetAttributes
        : Option[zio.aws.inspector.model.AssetAttributes.ReadOnly] = scala
      .Option(impl.assetAttributes())
      .map(value => zio.aws.inspector.model.AssetAttributes.wrap(value))
    override val id: Option[FindingId] = scala
      .Option(impl.id())
      .map(value => zio.aws.inspector.model.primitives.FindingId(value))
    override val title: Option[Text] = scala
      .Option(impl.title())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val description: Option[Text] = scala
      .Option(impl.description())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val recommendation: Option[Text] = scala
      .Option(impl.recommendation())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val severity: Option[zio.aws.inspector.model.Severity] = scala
      .Option(impl.severity())
      .map(value => zio.aws.inspector.model.Severity.wrap(value))
    override val numericSeverity: Option[NumericSeverity] = scala
      .Option(impl.numericSeverity())
      .map(value => zio.aws.inspector.model.primitives.NumericSeverity(value))
    override val confidence: Option[IocConfidence] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.inspector.model.primitives.IocConfidence(value))
    override val indicatorOfCompromise: Option[Bool] =
      scala.Option(impl.indicatorOfCompromise()).map(value => value: Bool)
    override val attributes: List[zio.aws.inspector.model.Attribute.ReadOnly] =
      impl
        .attributes()
        .asScala
        .map { item =>
          zio.aws.inspector.model.Attribute.wrap(item)
        }
        .toList
    override val userAttributes
        : List[zio.aws.inspector.model.Attribute.ReadOnly] = impl
      .userAttributes()
      .asScala
      .map { item =>
        zio.aws.inspector.model.Attribute.wrap(item)
      }
      .toList
    override val createdAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.createdAt())
    override val updatedAt: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.Finding
  ): zio.aws.inspector.model.Finding.ReadOnly = new Wrapper(impl)
}
