package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{Arn, AssessmentTargetName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAssessmentTargetRequest(
    assessmentTargetName: AssessmentTargetName,
    resourceGroupArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetRequest = {
    import CreateAssessmentTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetRequest
      .builder()
      .assessmentTargetName(
        AssessmentTargetName.unwrap(assessmentTargetName): java.lang.String
      )
      .optionallyWith(
        resourceGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.CreateAssessmentTargetRequest.ReadOnly =
    zio.aws.inspector.model.CreateAssessmentTargetRequest.wrap(buildAwsValue())
}
object CreateAssessmentTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.CreateAssessmentTargetRequest =
      zio.aws.inspector.model.CreateAssessmentTargetRequest(
        assessmentTargetName,
        resourceGroupArn.map(value => value)
      )
    def assessmentTargetName: AssessmentTargetName
    def resourceGroupArn: Option[Arn]
    def getAssessmentTargetName: ZIO[Any, Nothing, AssessmentTargetName] =
      ZIO.succeed(assessmentTargetName)
    def getResourceGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceGroupArn", resourceGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetRequest
  ) extends zio.aws.inspector.model.CreateAssessmentTargetRequest.ReadOnly {
    override val assessmentTargetName: AssessmentTargetName =
      zio.aws.inspector.model.primitives
        .AssessmentTargetName(impl.assessmentTargetName())
    override val resourceGroupArn: Option[Arn] = scala
      .Option(impl.resourceGroupArn())
      .map(value => zio.aws.inspector.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetRequest
  ): zio.aws.inspector.model.CreateAssessmentTargetRequest.ReadOnly =
    new Wrapper(impl)
}
