package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{
  AutoScalingGroup,
  Message,
  Arn,
  AgentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssessmentRunAgent(
    agentId: AgentId,
    assessmentRunArn: Arn,
    agentHealth: zio.aws.inspector.model.AgentHealth,
    agentHealthCode: zio.aws.inspector.model.AgentHealthCode,
    agentHealthDetails: Option[Message] = None,
    autoScalingGroup: Option[AutoScalingGroup] = None,
    telemetryMetadata: Iterable[zio.aws.inspector.model.TelemetryMetadata]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssessmentRunAgent = {
    import AssessmentRunAgent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssessmentRunAgent
      .builder()
      .agentId(AgentId.unwrap(agentId): java.lang.String)
      .assessmentRunArn(Arn.unwrap(assessmentRunArn): java.lang.String)
      .agentHealth(agentHealth.unwrap)
      .agentHealthCode(agentHealthCode.unwrap)
      .optionallyWith(
        agentHealthDetails.map(value => Message.unwrap(value): java.lang.String)
      )(_.agentHealthDetails)
      .optionallyWith(
        autoScalingGroup.map(value =>
          AutoScalingGroup.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroup)
      .telemetryMetadata(telemetryMetadata.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssessmentRunAgent.ReadOnly =
    zio.aws.inspector.model.AssessmentRunAgent.wrap(buildAwsValue())
}
object AssessmentRunAgent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssessmentRunAgent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssessmentRunAgent =
      zio.aws.inspector.model.AssessmentRunAgent(
        agentId,
        assessmentRunArn,
        agentHealth,
        agentHealthCode,
        agentHealthDetails.map(value => value),
        autoScalingGroup.map(value => value),
        telemetryMetadata.map { item =>
          item.asEditable
        }
      )
    def agentId: AgentId
    def assessmentRunArn: Arn
    def agentHealth: zio.aws.inspector.model.AgentHealth
    def agentHealthCode: zio.aws.inspector.model.AgentHealthCode
    def agentHealthDetails: Option[Message]
    def autoScalingGroup: Option[AutoScalingGroup]
    def telemetryMetadata
        : List[zio.aws.inspector.model.TelemetryMetadata.ReadOnly]
    def getAgentId: ZIO[Any, Nothing, AgentId] = ZIO.succeed(agentId)
    def getAssessmentRunArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentRunArn)
    def getAgentHealth: ZIO[Any, Nothing, zio.aws.inspector.model.AgentHealth] =
      ZIO.succeed(agentHealth)
    def getAgentHealthCode
        : ZIO[Any, Nothing, zio.aws.inspector.model.AgentHealthCode] =
      ZIO.succeed(agentHealthCode)
    def getAgentHealthDetails: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("agentHealthDetails", agentHealthDetails)
    def getAutoScalingGroup: ZIO[Any, AwsError, AutoScalingGroup] =
      AwsError.unwrapOptionField("autoScalingGroup", autoScalingGroup)
    def getTelemetryMetadata: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.TelemetryMetadata.ReadOnly
    ]] = ZIO.succeed(telemetryMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRunAgent
  ) extends zio.aws.inspector.model.AssessmentRunAgent.ReadOnly {
    override val agentId: AgentId =
      zio.aws.inspector.model.primitives.AgentId(impl.agentId())
    override val assessmentRunArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentRunArn())
    override val agentHealth: zio.aws.inspector.model.AgentHealth =
      zio.aws.inspector.model.AgentHealth.wrap(impl.agentHealth())
    override val agentHealthCode: zio.aws.inspector.model.AgentHealthCode =
      zio.aws.inspector.model.AgentHealthCode.wrap(impl.agentHealthCode())
    override val agentHealthDetails: Option[Message] = scala
      .Option(impl.agentHealthDetails())
      .map(value => zio.aws.inspector.model.primitives.Message(value))
    override val autoScalingGroup: Option[AutoScalingGroup] = scala
      .Option(impl.autoScalingGroup())
      .map(value => zio.aws.inspector.model.primitives.AutoScalingGroup(value))
    override val telemetryMetadata
        : List[zio.aws.inspector.model.TelemetryMetadata.ReadOnly] = impl
      .telemetryMetadata()
      .asScala
      .map { item =>
        zio.aws.inspector.model.TelemetryMetadata.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRunAgent
  ): zio.aws.inspector.model.AssessmentRunAgent.ReadOnly = new Wrapper(impl)
}
