package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait AgentHealth {
  def unwrap: software.amazon.awssdk.services.inspector.model.AgentHealth
}
object AgentHealth {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.AgentHealth
  ): zio.aws.inspector.model.AgentHealth = value match {
    case software.amazon.awssdk.services.inspector.model.AgentHealth.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.AgentHealth.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.inspector.model.AgentHealth.UNHEALTHY =>
      val r = UNHEALTHY
      r
    case software.amazon.awssdk.services.inspector.model.AgentHealth.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector.model.AgentHealth {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealth =
      software.amazon.awssdk.services.inspector.model.AgentHealth.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY extends zio.aws.inspector.model.AgentHealth {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealth =
      software.amazon.awssdk.services.inspector.model.AgentHealth.HEALTHY
  }
  case object UNHEALTHY extends zio.aws.inspector.model.AgentHealth {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealth =
      software.amazon.awssdk.services.inspector.model.AgentHealth.UNHEALTHY
  }
  case object UNKNOWN extends zio.aws.inspector.model.AgentHealth {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AgentHealth =
      software.amazon.awssdk.services.inspector.model.AgentHealth.UNKNOWN
  }
}
