package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeFindingsResponse(
    findings: Iterable[zio.aws.inspector.model.Finding],
    failedItems: Map[Arn, zio.aws.inspector.model.FailedItemDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeFindingsResponse = {
    import DescribeFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeFindingsResponse
      .builder()
      .findings(findings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .failedItems(
        failedItems
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.DescribeFindingsResponse.ReadOnly =
    zio.aws.inspector.model.DescribeFindingsResponse.wrap(buildAwsValue())
}
object DescribeFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeFindingsResponse =
      zio.aws.inspector.model.DescribeFindingsResponse(
        findings.map { item =>
          item.asEditable
        },
        failedItems.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def findings: List[zio.aws.inspector.model.Finding.ReadOnly]
    def failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly]
    def getFindings
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.Finding.ReadOnly]] =
      ZIO.succeed(findings)
    def getFailedItems: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.FailedItemDetails.ReadOnly
    ]] = ZIO.succeed(failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeFindingsResponse
  ) extends zio.aws.inspector.model.DescribeFindingsResponse.ReadOnly {
    override val findings: List[zio.aws.inspector.model.Finding.ReadOnly] = impl
      .findings()
      .asScala
      .map { item =>
        zio.aws.inspector.model.Finding.wrap(item)
      }
      .toList
    override val failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly] = impl
      .failedItems()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.FailedItemDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeFindingsResponse
  ): zio.aws.inspector.model.DescribeFindingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
