package zio.aws.inspector.model
import java.lang.Integer
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFindingsRequest(
    assessmentRunArns: Option[Iterable[Arn]] = None,
    filter: Option[zio.aws.inspector.model.FindingFilter] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ListMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListFindingsRequest = {
    import ListFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListFindingsRequest
      .builder()
      .optionallyWith(
        assessmentRunArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.assessmentRunArns)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListFindingsRequest.ReadOnly =
    zio.aws.inspector.model.ListFindingsRequest.wrap(buildAwsValue())
}
object ListFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListFindingsRequest =
      zio.aws.inspector.model.ListFindingsRequest(
        assessmentRunArns.map(value => value),
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentRunArns: Option[List[Arn]]
    def filter: Option[zio.aws.inspector.model.FindingFilter.ReadOnly]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ListMaxResults]
    def getAssessmentRunArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("assessmentRunArns", assessmentRunArns)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.inspector.model.FindingFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListFindingsRequest
  ) extends zio.aws.inspector.model.ListFindingsRequest.ReadOnly {
    override val assessmentRunArns: Option[List[Arn]] = scala
      .Option(impl.assessmentRunArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.Arn(item)
        }.toList
      )
    override val filter
        : Option[zio.aws.inspector.model.FindingFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.inspector.model.FindingFilter.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Option[ListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListFindingsRequest
  ): zio.aws.inspector.model.ListFindingsRequest.ReadOnly = new Wrapper(impl)
}
