package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Text
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExclusionPreview(
    title: Text,
    description: Text,
    recommendation: Text,
    scopes: Iterable[zio.aws.inspector.model.Scope],
    attributes: Option[Iterable[zio.aws.inspector.model.Attribute]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ExclusionPreview = {
    import ExclusionPreview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ExclusionPreview
      .builder()
      .title(Text.unwrap(title): java.lang.String)
      .description(Text.unwrap(description): java.lang.String)
      .recommendation(Text.unwrap(recommendation): java.lang.String)
      .scopes(scopes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ExclusionPreview.ReadOnly =
    zio.aws.inspector.model.ExclusionPreview.wrap(buildAwsValue())
}
object ExclusionPreview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ExclusionPreview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ExclusionPreview =
      zio.aws.inspector.model.ExclusionPreview(
        title,
        description,
        recommendation,
        scopes.map { item =>
          item.asEditable
        },
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def title: Text
    def description: Text
    def recommendation: Text
    def scopes: List[zio.aws.inspector.model.Scope.ReadOnly]
    def attributes: Option[List[zio.aws.inspector.model.Attribute.ReadOnly]]
    def getTitle: ZIO[Any, Nothing, Text] = ZIO.succeed(title)
    def getDescription: ZIO[Any, Nothing, Text] = ZIO.succeed(description)
    def getRecommendation: ZIO[Any, Nothing, Text] = ZIO.succeed(recommendation)
    def getScopes
        : ZIO[Any, Nothing, List[zio.aws.inspector.model.Scope.ReadOnly]] =
      ZIO.succeed(scopes)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ExclusionPreview
  ) extends zio.aws.inspector.model.ExclusionPreview.ReadOnly {
    override val title: Text =
      zio.aws.inspector.model.primitives.Text(impl.title())
    override val description: Text =
      zio.aws.inspector.model.primitives.Text(impl.description())
    override val recommendation: Text =
      zio.aws.inspector.model.primitives.Text(impl.recommendation())
    override val scopes: List[zio.aws.inspector.model.Scope.ReadOnly] = impl
      .scopes()
      .asScala
      .map { item =>
        zio.aws.inspector.model.Scope.wrap(item)
      }
      .toList
    override val attributes
        : Option[List[zio.aws.inspector.model.Attribute.ReadOnly]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.Attribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ExclusionPreview
  ): zio.aws.inspector.model.ExclusionPreview.ReadOnly = new Wrapper(impl)
}
