package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Text
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkInterface(
    networkInterfaceId: Option[Text] = None,
    subnetId: Option[Text] = None,
    vpcId: Option[Text] = None,
    privateDnsName: Option[Text] = None,
    privateIpAddress: Option[Text] = None,
    privateIpAddresses: Option[Iterable[zio.aws.inspector.model.PrivateIp]] =
      None,
    publicDnsName: Option[Text] = None,
    publicIp: Option[Text] = None,
    ipv6Addresses: Option[Iterable[Text]] = None,
    securityGroups: Option[Iterable[zio.aws.inspector.model.SecurityGroup]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.NetworkInterface
      .builder()
      .optionallyWith(
        networkInterfaceId.map(value => Text.unwrap(value): java.lang.String)
      )(_.networkInterfaceId)
      .optionallyWith(
        subnetId.map(value => Text.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(vpcId.map(value => Text.unwrap(value): java.lang.String))(
        _.vpcId
      )
      .optionallyWith(
        privateDnsName.map(value => Text.unwrap(value): java.lang.String)
      )(_.privateDnsName)
      .optionallyWith(
        privateIpAddress.map(value => Text.unwrap(value): java.lang.String)
      )(_.privateIpAddress)
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        publicDnsName.map(value => Text.unwrap(value): java.lang.String)
      )(_.publicDnsName)
      .optionallyWith(
        publicIp.map(value => Text.unwrap(value): java.lang.String)
      )(_.publicIp)
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            Text.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.NetworkInterface.ReadOnly =
    zio.aws.inspector.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.NetworkInterface =
      zio.aws.inspector.model.NetworkInterface(
        networkInterfaceId.map(value => value),
        subnetId.map(value => value),
        vpcId.map(value => value),
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        publicDnsName.map(value => value),
        publicIp.map(value => value),
        ipv6Addresses.map(value => value),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInterfaceId: Option[Text]
    def subnetId: Option[Text]
    def vpcId: Option[Text]
    def privateDnsName: Option[Text]
    def privateIpAddress: Option[Text]
    def privateIpAddresses
        : Option[List[zio.aws.inspector.model.PrivateIp.ReadOnly]]
    def publicDnsName: Option[Text]
    def publicIp: Option[Text]
    def ipv6Addresses: Option[List[Text]]
    def securityGroups
        : Option[List[zio.aws.inspector.model.SecurityGroup.ReadOnly]]
    def getNetworkInterfaceId: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getSubnetId: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getPrivateDnsName: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.PrivateIp.ReadOnly]] =
      AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getPublicDnsName: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIp: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getIpv6Addresses: ZIO[Any, AwsError, List[Text]] =
      AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.inspector.model.SecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.NetworkInterface
  ) extends zio.aws.inspector.model.NetworkInterface.ReadOnly {
    override val networkInterfaceId: Option[Text] = scala
      .Option(impl.networkInterfaceId())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val subnetId: Option[Text] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val vpcId: Option[Text] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val privateDnsName: Option[Text] = scala
      .Option(impl.privateDnsName())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val privateIpAddress: Option[Text] = scala
      .Option(impl.privateIpAddress())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val privateIpAddresses
        : Option[List[zio.aws.inspector.model.PrivateIp.ReadOnly]] = scala
      .Option(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.PrivateIp.wrap(item)
        }.toList
      )
    override val publicDnsName: Option[Text] = scala
      .Option(impl.publicDnsName())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val publicIp: Option[Text] = scala
      .Option(impl.publicIp())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val ipv6Addresses: Option[List[Text]] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.Text(item)
        }.toList
      )
    override val securityGroups
        : Option[List[zio.aws.inspector.model.SecurityGroup.ReadOnly]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.SecurityGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.NetworkInterface
  ): zio.aws.inspector.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
