package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{Arn, Bool, Message, Timestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AssessmentRunNotification(
    date: Timestamp,
    event: zio.aws.inspector.model.InspectorEvent,
    message: Option[Message] = None,
    error: Bool,
    snsTopicArn: Option[Arn] = None,
    snsPublishStatusCode: Option[
      zio.aws.inspector.model.AssessmentRunNotificationSnsStatusCode
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssessmentRunNotification = {
    import AssessmentRunNotification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssessmentRunNotification
      .builder()
      .date(Timestamp.unwrap(date): Instant)
      .event(event.unwrap)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .error(Bool.unwrap(error): java.lang.Boolean)
      .optionallyWith(
        snsTopicArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(snsPublishStatusCode.map(value => value.unwrap))(
        _.snsPublishStatusCode
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssessmentRunNotification.ReadOnly =
    zio.aws.inspector.model.AssessmentRunNotification.wrap(buildAwsValue())
}
object AssessmentRunNotification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssessmentRunNotification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssessmentRunNotification =
      zio.aws.inspector.model.AssessmentRunNotification(
        date,
        event,
        message.map(value => value),
        error,
        snsTopicArn.map(value => value),
        snsPublishStatusCode.map(value => value)
      )
    def date: Timestamp
    def event: zio.aws.inspector.model.InspectorEvent
    def message: Option[Message]
    def error: Bool
    def snsTopicArn: Option[Arn]
    def snsPublishStatusCode
        : Option[zio.aws.inspector.model.AssessmentRunNotificationSnsStatusCode]
    def getDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(date)
    def getEvent: ZIO[Any, Nothing, zio.aws.inspector.model.InspectorEvent] =
      ZIO.succeed(event)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getError: ZIO[Any, Nothing, Bool] = ZIO.succeed(error)
    def getSnsTopicArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSnsPublishStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.inspector.model.AssessmentRunNotificationSnsStatusCode
    ] = AwsError.unwrapOptionField("snsPublishStatusCode", snsPublishStatusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRunNotification
  ) extends zio.aws.inspector.model.AssessmentRunNotification.ReadOnly {
    override val date: Timestamp =
      zio.aws.inspector.model.primitives.Timestamp(impl.date())
    override val event: zio.aws.inspector.model.InspectorEvent =
      zio.aws.inspector.model.InspectorEvent.wrap(impl.event())
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.inspector.model.primitives.Message(value))
    override val error: Bool =
      zio.aws.inspector.model.primitives.Bool(impl.error())
    override val snsTopicArn: Option[Arn] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.inspector.model.primitives.Arn(value))
    override val snsPublishStatusCode: Option[
      zio.aws.inspector.model.AssessmentRunNotificationSnsStatusCode
    ] = scala
      .Option(impl.snsPublishStatusCode())
      .map(value =>
        zio.aws.inspector.model.AssessmentRunNotificationSnsStatusCode
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentRunNotification
  ): zio.aws.inspector.model.AssessmentRunNotification.ReadOnly = new Wrapper(
    impl
  )
}
