package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{
  Arn,
  RuleName,
  AutoScalingGroup,
  AgentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FindingFilter(
    agentIds: Option[Iterable[AgentId]] = None,
    autoScalingGroups: Option[Iterable[AutoScalingGroup]] = None,
    ruleNames: Option[Iterable[RuleName]] = None,
    severities: Option[Iterable[zio.aws.inspector.model.Severity]] = None,
    rulesPackageArns: Option[Iterable[Arn]] = None,
    attributes: Option[Iterable[zio.aws.inspector.model.Attribute]] = None,
    userAttributes: Option[Iterable[zio.aws.inspector.model.Attribute]] = None,
    creationTimeRange: Option[zio.aws.inspector.model.TimestampRange] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.FindingFilter = {
    import FindingFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.FindingFilter
      .builder()
      .optionallyWith(
        agentIds.map(value =>
          value.map { item =>
            AgentId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentIds)
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            AutoScalingGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(
        ruleNames.map(value =>
          value.map { item =>
            RuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ruleNames)
      .optionallyWith(
        severities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.severitiesWithStrings)
      .optionallyWith(
        rulesPackageArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rulesPackageArns)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        userAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAttributes)
      .optionallyWith(creationTimeRange.map(value => value.buildAwsValue()))(
        _.creationTimeRange
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.FindingFilter.ReadOnly =
    zio.aws.inspector.model.FindingFilter.wrap(buildAwsValue())
}
object FindingFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.FindingFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.FindingFilter =
      zio.aws.inspector.model.FindingFilter(
        agentIds.map(value => value),
        autoScalingGroups.map(value => value),
        ruleNames.map(value => value),
        severities.map(value => value),
        rulesPackageArns.map(value => value),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTimeRange.map(value => value.asEditable)
      )
    def agentIds: Option[List[AgentId]]
    def autoScalingGroups: Option[List[AutoScalingGroup]]
    def ruleNames: Option[List[RuleName]]
    def severities: Option[List[zio.aws.inspector.model.Severity]]
    def rulesPackageArns: Option[List[Arn]]
    def attributes: Option[List[zio.aws.inspector.model.Attribute.ReadOnly]]
    def userAttributes: Option[List[zio.aws.inspector.model.Attribute.ReadOnly]]
    def creationTimeRange
        : Option[zio.aws.inspector.model.TimestampRange.ReadOnly]
    def getAgentIds: ZIO[Any, AwsError, List[AgentId]] =
      AwsError.unwrapOptionField("agentIds", agentIds)
    def getAutoScalingGroups: ZIO[Any, AwsError, List[AutoScalingGroup]] =
      AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getRuleNames: ZIO[Any, AwsError, List[RuleName]] =
      AwsError.unwrapOptionField("ruleNames", ruleNames)
    def getSeverities
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Severity]] =
      AwsError.unwrapOptionField("severities", severities)
    def getRulesPackageArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("rulesPackageArns", rulesPackageArns)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getUserAttributes
        : ZIO[Any, AwsError, List[zio.aws.inspector.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("userAttributes", userAttributes)
    def getCreationTimeRange
        : ZIO[Any, AwsError, zio.aws.inspector.model.TimestampRange.ReadOnly] =
      AwsError.unwrapOptionField("creationTimeRange", creationTimeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.FindingFilter
  ) extends zio.aws.inspector.model.FindingFilter.ReadOnly {
    override val agentIds: Option[List[AgentId]] = scala
      .Option(impl.agentIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.AgentId(item)
        }.toList
      )
    override val autoScalingGroups: Option[List[AutoScalingGroup]] = scala
      .Option(impl.autoScalingGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.AutoScalingGroup(item)
        }.toList
      )
    override val ruleNames: Option[List[RuleName]] = scala
      .Option(impl.ruleNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.RuleName(item)
        }.toList
      )
    override val severities: Option[List[zio.aws.inspector.model.Severity]] =
      scala
        .Option(impl.severities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.Severity.wrap(item)
          }.toList
        )
    override val rulesPackageArns: Option[List[Arn]] = scala
      .Option(impl.rulesPackageArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.Arn(item)
        }.toList
      )
    override val attributes
        : Option[List[zio.aws.inspector.model.Attribute.ReadOnly]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.Attribute.wrap(item)
        }.toList
      )
    override val userAttributes
        : Option[List[zio.aws.inspector.model.Attribute.ReadOnly]] = scala
      .Option(impl.userAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.Attribute.wrap(item)
        }.toList
      )
    override val creationTimeRange
        : Option[zio.aws.inspector.model.TimestampRange.ReadOnly] = scala
      .Option(impl.creationTimeRange())
      .map(value => zio.aws.inspector.model.TimestampRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.FindingFilter
  ): zio.aws.inspector.model.FindingFilter.ReadOnly = new Wrapper(impl)
}
