package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TimestampRange(
    beginDate: Option[Timestamp] = None,
    endDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.TimestampRange = {
    import TimestampRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.TimestampRange
      .builder()
      .optionallyWith(beginDate.map(value => Timestamp.unwrap(value): Instant))(
        _.beginDate
      )
      .optionallyWith(endDate.map(value => Timestamp.unwrap(value): Instant))(
        _.endDate
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.TimestampRange.ReadOnly =
    zio.aws.inspector.model.TimestampRange.wrap(buildAwsValue())
}
object TimestampRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.TimestampRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.TimestampRange =
      zio.aws.inspector.model.TimestampRange(
        beginDate.map(value => value),
        endDate.map(value => value)
      )
    def beginDate: Option[Timestamp]
    def endDate: Option[Timestamp]
    def getBeginDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("beginDate", beginDate)
    def getEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endDate", endDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.TimestampRange
  ) extends zio.aws.inspector.model.TimestampRange.ReadOnly {
    override val beginDate: Option[Timestamp] = scala
      .Option(impl.beginDate())
      .map(value => zio.aws.inspector.model.primitives.Timestamp(value))
    override val endDate: Option[Timestamp] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.inspector.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.TimestampRange
  ): zio.aws.inspector.model.TimestampRange.ReadOnly = new Wrapper(impl)
}
