package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Text
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SecurityGroup(
    groupName: Option[Text] = None,
    groupId: Option[Text] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.SecurityGroup = {
    import SecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.SecurityGroup
      .builder()
      .optionallyWith(
        groupName.map(value => Text.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupId.map(value => Text.unwrap(value): java.lang.String)
      )(_.groupId)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.SecurityGroup.ReadOnly =
    zio.aws.inspector.model.SecurityGroup.wrap(buildAwsValue())
}
object SecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.SecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.SecurityGroup =
      zio.aws.inspector.model.SecurityGroup(
        groupName.map(value => value),
        groupId.map(value => value)
      )
    def groupName: Option[Text]
    def groupId: Option[Text]
    def getGroupName: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupId: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("groupId", groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.SecurityGroup
  ) extends zio.aws.inspector.model.SecurityGroup.ReadOnly {
    override val groupName: Option[Text] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
    override val groupId: Option[Text] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.inspector.model.primitives.Text(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.SecurityGroup
  ): zio.aws.inspector.model.SecurityGroup.ReadOnly = new Wrapper(impl)
}
