package zio.aws.inspector.model
import java.lang.Integer
import zio.aws.inspector.model.primitives.{Arn, NumericVersion}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InspectorServiceAttributes(
    schemaVersion: NumericVersion,
    assessmentRunArn: Option[Arn] = None,
    rulesPackageArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.InspectorServiceAttributes = {
    import InspectorServiceAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.InspectorServiceAttributes
      .builder()
      .schemaVersion(NumericVersion.unwrap(schemaVersion): Integer)
      .optionallyWith(
        assessmentRunArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.assessmentRunArn)
      .optionallyWith(
        rulesPackageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.rulesPackageArn)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.InspectorServiceAttributes.ReadOnly =
    zio.aws.inspector.model.InspectorServiceAttributes.wrap(buildAwsValue())
}
object InspectorServiceAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.InspectorServiceAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.InspectorServiceAttributes =
      zio.aws.inspector.model.InspectorServiceAttributes(
        schemaVersion,
        assessmentRunArn.map(value => value),
        rulesPackageArn.map(value => value)
      )
    def schemaVersion: NumericVersion
    def assessmentRunArn: Option[Arn]
    def rulesPackageArn: Option[Arn]
    def getSchemaVersion: ZIO[Any, Nothing, NumericVersion] =
      ZIO.succeed(schemaVersion)
    def getAssessmentRunArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("assessmentRunArn", assessmentRunArn)
    def getRulesPackageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("rulesPackageArn", rulesPackageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.InspectorServiceAttributes
  ) extends zio.aws.inspector.model.InspectorServiceAttributes.ReadOnly {
    override val schemaVersion: NumericVersion =
      zio.aws.inspector.model.primitives.NumericVersion(impl.schemaVersion())
    override val assessmentRunArn: Option[Arn] = scala
      .Option(impl.assessmentRunArn())
      .map(value => zio.aws.inspector.model.primitives.Arn(value))
    override val rulesPackageArn: Option[Arn] = scala
      .Option(impl.rulesPackageArn())
      .map(value => zio.aws.inspector.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.InspectorServiceAttributes
  ): zio.aws.inspector.model.InspectorServiceAttributes.ReadOnly = new Wrapper(
    impl
  )
}
