package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAssessmentRunsResponse(
    assessmentRuns: Iterable[zio.aws.inspector.model.AssessmentRun],
    failedItems: Map[Arn, zio.aws.inspector.model.FailedItemDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsResponse = {
    import DescribeAssessmentRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsResponse
      .builder()
      .assessmentRuns(assessmentRuns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .failedItems(
        failedItems
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeAssessmentRunsResponse.ReadOnly =
    zio.aws.inspector.model.DescribeAssessmentRunsResponse.wrap(buildAwsValue())
}
object DescribeAssessmentRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeAssessmentRunsResponse =
      zio.aws.inspector.model.DescribeAssessmentRunsResponse(
        assessmentRuns.map { item =>
          item.asEditable
        },
        failedItems.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def assessmentRuns: List[zio.aws.inspector.model.AssessmentRun.ReadOnly]
    def failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly]
    def getAssessmentRuns: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.AssessmentRun.ReadOnly
    ]] = ZIO.succeed(assessmentRuns)
    def getFailedItems: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.FailedItemDetails.ReadOnly
    ]] = ZIO.succeed(failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsResponse
  ) extends zio.aws.inspector.model.DescribeAssessmentRunsResponse.ReadOnly {
    override val assessmentRuns
        : List[zio.aws.inspector.model.AssessmentRun.ReadOnly] = impl
      .assessmentRuns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.AssessmentRun.wrap(item)
      }
      .toList
    override val failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly] = impl
      .failedItems()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.FailedItemDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsResponse
  ): zio.aws.inspector.model.DescribeAssessmentRunsResponse.ReadOnly =
    new Wrapper(impl)
}
